/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2020 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview TrustCenterController
 */

var PKIXCommon = require("scsh/x509/PKIXCommon").PKIXCommon;
var MenuModel = require('pki-as-a-service/ui/MenuModel').MenuModel;



function TrustCenterController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new TrustCenterController()");
}

exports.TrustCenterController = TrustCenterController;



TrustCenterController.prototype.getView = function(req, res, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div />;

	var homeURL = subjectController.ui.homeURL(req.url);

	div.appendChild( <h2>{subject.getName()}</h2> );

	var certTable = subjectController.renderCertificate(subject, homeURL);
	if (certTable) {
		div.appendChild( <h2>CA Certificates</h2> );
		div.appendChild(certTable);
	}

	div.appendChild( <h2>CA Token</h2> );
	div.appendChild(subjectController.renderToken(subject, homeURL));

	var roles = <div><ul/></div>;
	if (subject.bo.managedByRoleId != null) {
		roles.ul.li += <li><a href={homeURL + "/role/" + subject.bo.managedByRoleId}>TrustCenter Manager</a></li>;
	}
	if (subject.getRARoleId()) {
		roles.ul.li += <li><a href={homeURL + "/role/" + subject.getRARoleId()}>Registration Officer</a></li>;
	}
	if (subject.getCARoleId()) {
		roles.ul.li += <li><a href={homeURL + "/role/" + subject.getCARoleId()}>Certification Officer</a></li>;
	}
	if (roles.ul.length() > 0) {
		div.appendChild( <h2>Roles</h2> );
		div.appendChild(roles);
	}

	return div;
}



TrustCenterController.prototype.getMenuModel = function(req, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var user = subjectController.ui.session.user;

	var homeURL = subjectController.ui.homeURL(req.url);
	var model = new MenuModel(<p class="no-margin">CA</p>);

	if (subject.isRegistrationOfficer(user)) {
		model.addItem(<a href={homeURL + "/sr/new?process=CreateX509SignerServiceRequest&ca=" + subject.getId()}>Create Signer</a>);
		model.addItem(<a href={homeURL + "/sr/new?process=ImportX509SignerServiceRequest&ca=" + subject.getId()}>Import Signer</a>);
		model.addItem(<a href={homeURL + "/sr/new?process=EnrollSystemServiceRequest&ca=" + subject.getId()}>Enroll System</a>);
		model.addItem(<a href={homeURL + "/sr/new?process=EnrollPersonServiceRequest&ca=" + subject.getId()}>Enroll Person</a>);

		var process = "CreateGroupManagerServiceRequest";
		var factory = subjectController.service.pluginRegistry.getFactoryForProcess(process);
		if (factory) {
			model.addItem(<a href={homeURL + "/sr/new?process=" + process + "&ca=" + subject.getId()}>Create Group Manager</a>);
		}
	}

	if (subject.isCertificationOfficer(user)) {
		model.addItem(<a href={homeURL + "/sr/new?process=IssueCRLServiceRequest&ca=" + subject.getId()}>Issue CRL</a>);
	}

	if (model.hasChildren) {
		return model;
	}
}
