/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2017 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Controller for Person and System subjects
 */

var MenuModel = require('pki-as-a-service/ui/MenuModel').MenuModel;
var Person = require('pki-as-a-service/subjects/Person').Person;



function BaseSubjectController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new BaseSubjectController()");
}

exports.BaseSubjectController = BaseSubjectController;



BaseSubjectController.prototype.getView = function(req, res, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var homeURL = subjectController.ui.homeURL(req.url);

	var roleDAO = subjectController.service.daof.getRoleDAO();

	var div = <div />;

	var subjectDetails =
		<div>
			<h2>Subject Details</h2>
			<table class="pure-table pure-table-horizontal form-table"/>
		</div>;

	var table = subjectDetails..table;

	if (subject.getName()) {
		table.tr +=
			<tr>
				<th>Name</th>
				<td>{subject.getName()}</td>
			</tr>;
	}

	if (subject.getEmail()) {
		table.tr +=
			<tr>
				<th>Email</th>
				<td>{subject.getEmail()}</td>
			</tr>;
	}

	table.tr +=
		<tr>
			<th>Assurance Level</th>
			<td>{subject.bo.assuranceLevel}</td>
		</tr>;

	if (subject.bo.serviceRequestId) {
		var url = homeURL + "/sr/" + subject.bo.serviceRequestId;

		table.tr +=
			<tr>
				<th>Service Request</th>
				<td><a href={url}>{subject.bo.serviceRequestId}</a></td>
			</tr>;
	}

	if (subject.bo.managedByRoleId != null) {
		var managingRole = roleDAO.getRoleById(subject.bo.managedByRoleId);
		var url = homeURL + "/role/" + managingRole.id;
		var table = subjectDetails..table;
		table.tr +=
			<tr>
				<th>Managed By</th>
				<td><a href={url}>{managingRole.name}</a></td>
			</tr>;
	}

	div.appendChild(subjectDetails);

	var assignedRoles = subjectController.renderAssignedRoles(subject, homeURL);
	if (assignedRoles) {
		div.appendChild(assignedRoles);
	}

	var certTable = subjectController.renderCertificate(subject, homeURL);
	if (certTable) {
		div.appendChild( <h2>Certificates</h2> );
		div.appendChild(certTable);
	}

	div.appendChild( <h2>Token</h2> );
	div.appendChild(subjectController.renderToken(subject, homeURL));

	return div;
}



BaseSubjectController.prototype.getMenuModel = function(req, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var homeURL = subjectController.ui.homeURL(req.url);

	var menuModel = new MenuModel(<p class="no-margin">Subject</p>);

	if (subject instanceof Person) {
		var user = subjectController.ui.session.user;

		// If no role is assigned to the current user
		// then ManageRoleServiceRequest cannot
		// add or remove any role
		if (user.roles && user.roles.length > 0) {
			var url = homeURL + "/sr/new?process=ManageRoleServiceRequest&subject=" + subject.getId();
			menuModel.addItem(<a href={url}>Manage Role</a>);
		}
	}

	var trustCenterId = subject.getTrustCenterId();

	if (trustCenterId) {
		var url = homeURL + "/sr/new?process=IssueTokenServiceRequest";
		url += "&subject=" + subject.bo.id;
		menuModel.addItem(<a href={url}>Issue Token</a>);

		return menuModel;
	}

	return menuModel;
}
