/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2017 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview HTML menu model
 */



/*
 * Example Model
 *
 * menu = {
 * 	item: root,
 * 	children: [
 * 		{
 * 			item: A,
 * 			children: []
 * 		}, {
 * 			item: B,
 * 			children: []
 * 		}, {
 * 			item: C,
 * 			children: [
 * 				{
 * 					item: C2,
 * 					children: []
 * 				}
 * 			]
 * 		}
 * 	]
 * }
 */

function MenuModel(item) {
	this.item = item;
	this.children = [];

	/*
	 * selected, normal, disabled
	 */
	this.status;
}

exports.MenuModel = MenuModel;



MenuModel.STATE_SELECTED = "selected";
MenuModel.STATE_NORMAL = "normal";
MenuModel.STATE_DISABLED = "disabled";
MenuModel.STATE_PRE_RENDERED = "pre_rendered";



MenuModel.prototype.addItem = function(item)  {
	if (item instanceof MenuModel) {
		this.children.push(item);
	} else {
		var menu = new MenuModel(item);
		this.children.push(menu);
	}
}



MenuModel.prototype.insertAfterChild = function(child, item)  {
	var menu = null;
	if (item instanceof MenuModel) {
		menu = item;
	} else {
		menu = new MenuModel(item);
	}

	var index = this.children.indexOf(child);
	if (index < 0) {
		return false;
	}
	this.children.splice(index, 0, menu);
}



MenuModel.prototype.hasChildren = function()  {
	return this.children.length > 0;
}


/**
 * @type MenuModel
 */
MenuModel.prototype.getChildren = function()  {
	return this.children;
}



MenuModel.prototype.getItem = function() {
	return this.item;
}



MenuModel.prototype.deleteChild = function(child) {
	var index = this.children.indexOf(child);
	this.children.splice(index, 1);
}



MenuModel.prototype.isEmpty = function() {
	return !this.item && !this.hasChildren();
}