/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAPrivateKeySpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import org.openscdp.pkidm.cvc.CryptoProvider;
import org.openscdp.pkidm.cvc.CryptoProviderException;

public class HSMCryptoProvider
implements CryptoProvider {
    private SmartCardHSMProvider provider;

    public HSMCryptoProvider(SmartCardHSMProvider provider) {
        this.provider = provider;
    }

    @Override
    public Provider getProvider() {
        return this.provider;
    }

    @Override
    public KeyPair generateKeyPair(AlgorithmParameterSpec params, String alias) throws CryptoProviderException {
        SmartCardHSMParameterSpec spec = (SmartCardHSMParameterSpec)params;
        spec.setLabel(alias);
        try {
            KeyStore keyStore = KeyStore.getInstance("SmartCardHSMKeyStore", this.getProvider());
            keyStore.load(null, null);
            if (keyStore.containsAlias(spec.getLabel())) {
                keyStore.deleteEntry(spec.getLabel());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            e.printStackTrace();
        }
        try {
            KeyPairGenerator kpg;
            if (spec.getKeySpec() instanceof SmartCardHSMECPrivateKeySpec) {
                kpg = KeyPairGenerator.getInstance("EC//ECDSA-SHA-256", this.getProvider());
            } else if (spec.getKeySpec() instanceof SmartCardHSMRSAPrivateKeySpec) {
                kpg = KeyPairGenerator.getInstance("RSA", this.getProvider());
            } else {
                throw new InvalidParameterException("Invalid AlgorithmParameterSpec");
            }
            kpg.initialize(params, null);
            KeyPair kp = kpg.generateKeyPair();
            return kp;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new CryptoProviderException("generate key pair failed with", e);
        }
    }

    @Override
    public PrivateKey getPrivateKey(byte[] keyId, byte[] keyDomain, byte[] keyblob) throws CryptoProviderException {
        try {
            KeyStore keyStore = KeyStore.getInstance("SmartCardHSMKeyStore", this.getProvider());
            keyStore.load(null, null);
            String alias = new String(keyId);
            return (PrivateKey)keyStore.getKey(alias, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new CryptoProviderException("get private key failed with", e);
        }
    }
}

