/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pdf.service.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pdf.service.PDFGenerator;
import org.openscdp.pdf.service.servicerequest.PDFServiceRequest;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.json.JSONAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sr")
public class ServiceRequestResource {
    private final Logger logger = LoggerFactory.getLogger(ServiceRequestResource.class);

    @POST
    @Path(value="/{id}/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postAction(@Context HttpServletRequest req, @PathParam(value="id") Long id, JSONAction action) {
        PDFGenerator gen = (PDFGenerator)req.getServletContext().getAttribute("PDFGEN");
        String clientdir = req.getServletContext().getInitParameter("clientdir");
        ServiceRequestDTO dto = this.loadServiceRequest(id);
        PDFServiceRequest sr = new PDFServiceRequest(dto, gen, clientdir);
        ServiceRequestAction sra = sr.getActionFor(action);
        return Response.ok((Object)sra.execute()).build();
    }

    private ServiceRequestDTO loadServiceRequest(Long id) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            ServiceRequestDTO dto = dao.getServiceRequest(id);
            if (dto == null) {
                this.logger.error("Service request " + id + " not found");
                throw new NotFoundException();
            }
            ServiceRequestDTO serviceRequestDTO = dto;
            return serviceRequestDTO;
        }
    }
}

