/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pdf.service;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.text.XTextFieldsSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XRefreshable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFGenerator {
    private static final String FIELD_ID = "com.sun.star.text.fieldmaster.User.";
    final Logger logger = LoggerFactory.getLogger(PDFGenerator.class);
    private String unoURL;
    private String serverdir;
    private String clientdir;
    private HashMap<String, String> templates;
    XComponentLoader _officeComponentLoader = null;
    XComponentContext _ctx;

    public PDFGenerator(String unoURL, String serverdir, String clientdir) {
        this.unoURL = unoURL;
        this.serverdir = serverdir;
        this.clientdir = clientdir;
    }

    protected String[] parseUnoURL(String unoUrl) {
        if (!unoUrl.startsWith("uno:")) {
            this.logger.error("Not a UNO URL " + unoUrl);
            throw new java.lang.IllegalArgumentException("Not a UNO URL " + unoUrl);
        }
        String url = unoUrl.substring("uno:".length());
        String[] a = url.split(";");
        return a;
    }

    protected XComponentLoader getComponentLoader() throws Exception {
        XComponentLoader officeComponentLoader = this._officeComponentLoader;
        if (this._ctx == null) {
            this._ctx = Bootstrap.createInitialComponentContext(null);
        }
        if (officeComponentLoader == null) {
            XPropertySet xProperySet;
            Object oDefaultContext;
            XComponentContext xOfficeComponentContext;
            Object x = this._ctx.getServiceManager().createInstanceWithContext("com.sun.star.connection.Connector", this._ctx);
            XConnector xConnector = (XConnector)UnoRuntime.queryInterface(XConnector.class, (Object)x);
            String[] a = this.parseUnoURL(this.unoURL);
            if (null == a) {
                throw new com.sun.star.uno.Exception("Couldn't parse UNO URL " + this.unoURL);
            }
            XConnection connection = xConnector.connect(a[0]);
            x = this._ctx.getServiceManager().createInstanceWithContext("com.sun.star.bridge.BridgeFactory", this._ctx);
            XBridgeFactory xBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, (Object)x);
            XBridge bridge = xBridgeFactory.createBridge("", a[1], connection, null);
            if (null == (x = bridge.getInstance(a[2]))) {
                throw new com.sun.star.uno.Exception("Server didn't provide an instance for" + a[2], null);
            }
            XMultiComponentFactory xOfficeMultiComponentFactory = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)x);
            Object oDesktop = xOfficeMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", xOfficeComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)(oDefaultContext = (xProperySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xOfficeMultiComponentFactory)).getPropertyValue("DefaultContext"))));
            officeComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
            if (officeComponentLoader == null) {
                throw new com.sun.star.uno.Exception("Couldn't instantiate com.sun.star.frame.Desktop", null);
            }
            this._officeComponentLoader = officeComponentLoader;
        }
        return officeComponentLoader;
    }

    protected XComponent getNewDocComponentFromTemplate(String fileUrl) throws Exception {
        if (!fileUrl.startsWith("file:/")) {
            this.logger.error("Not a file URL " + fileUrl);
            throw new java.lang.IllegalArgumentException("Not a file URL " + fileUrl);
        }
        XComponentLoader xComponentLoader = this.getComponentLoader();
        PropertyValue[] loadProps = new PropertyValue[2];
        loadProps[0] = new PropertyValue();
        loadProps[0].Name = "AsTemplate";
        loadProps[0].Value = new Boolean(true);
        loadProps[1] = new PropertyValue();
        loadProps[1].Name = "Hidden";
        loadProps[1].Value = new Boolean(true);
        return xComponentLoader.loadComponentFromURL(fileUrl, "_blank", 0, loadProps);
    }

    protected void exportAsPDF(XComponent doc, String fileUrl) throws IOException {
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(XStorable.class, (Object)doc);
        PropertyValue[] propertyValues = new PropertyValue[2];
        propertyValues[0] = new PropertyValue();
        propertyValues[0].Name = "Overwrite";
        propertyValues[0].Value = new Boolean(true);
        propertyValues[1] = new PropertyValue();
        propertyValues[1].Name = "FilterName";
        propertyValues[1].Value = "writer_pdf_Export";
        xStorable.storeToURL(fileUrl, propertyValues);
        this.logger.info("Saved " + fileUrl);
    }

    protected void setFields(XComponent template, Map<String, String> map) throws NoSuchElementException, WrappedTargetException, IllegalArgumentException, UnknownPropertyException, PropertyVetoException {
        XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)template);
        XNameAccess xNamedFieldMasters = xTextFieldsSupplier.getTextFieldMasters();
        XEnumerationAccess xEnumeratedFields = xTextFieldsSupplier.getTextFields();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            try {
                Object fieldMaster = xNamedFieldMasters.getByName(FIELD_ID + key);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)fieldMaster);
                xPropertySet.setPropertyValue("Content", (Object)val);
            }
            catch (NoSuchElementException e) {
                this.logger.error("Field " + key + " not found");
            }
        }
        XRefreshable xRefreshable = (XRefreshable)UnoRuntime.queryInterface(XRefreshable.class, (Object)xEnumeratedFields);
        xRefreshable.refresh();
    }

    protected List<String> getFieldKeys(XComponent template) {
        XTextFieldsSupplier xTextFieldsSupplier = (XTextFieldsSupplier)UnoRuntime.queryInterface(XTextFieldsSupplier.class, (Object)template);
        XNameAccess xNamedFieldMasters = xTextFieldsSupplier.getTextFieldMasters();
        String[] names = xNamedFieldMasters.getElementNames();
        LinkedList<String> userFieldKeys = new LinkedList<String>();
        for (String name : names) {
            if (!name.startsWith(FIELD_ID)) continue;
            userFieldKeys.add(name);
        }
        return userFieldKeys;
    }

    protected void process() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource("TextTemplateWithUserFields.odt");
        this.logger.info("File url " + String.valueOf(url));
        this.logger.info(url.toExternalForm());
        this.logger.info(url.getFile());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", "CC");
        map.put("Contact", "Max Mustermann");
        map.put("ZIP", "32429");
        map.put("City", "Minden");
        map.put("State", "Germany");
        String fileUrl = "file:///" + url.getFile();
        XComponent doc = this.getNewDocComponentFromTemplate(fileUrl);
        this.getFieldKeys(doc);
        this.setFields(doc, map);
        this.exportAsPDF(doc, fileUrl + ".pdf");
        doc.dispose();
    }

    public byte[] getPDFFromTemplate(String template, Map<String, String> map) throws Exception {
        byte[] pdf;
        String templateURL = "file://" + this.serverdir + "/template/" + template + ".odt";
        XComponent doc = this.getNewDocComponentFromTemplate(templateURL);
        this.setFields(doc, map);
        String tmpFileName = "tmp";
        String tempURL = "file://" + this.serverdir + "/output/" + tmpFileName + ".pdf";
        this.exportAsPDF(doc, tempURL);
        doc.dispose();
        tempURL = this.clientdir + "/output/" + tmpFileName + ".pdf";
        File tempFile = new File(tempURL);
        FileInputStream fis = new FileInputStream(tempFile);
        try (DataInputStream dis = new DataInputStream(fis);){
            int n = dis.available();
            pdf = new byte[n];
            if (n > 0) {
                dis.read(pdf);
            }
        }
        tempFile.delete();
        return pdf;
    }
}

