/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow.receive;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.TLVEncodingException;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertificateException;
import java.util.LinkedList;
import java.util.List;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkicard.escrow.SmartCardHSMCertificateChainTLV;
import org.openscdp.pkicard.escrow.XKEKKeyDomain;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowContent;
import org.openscdp.pkicard.escrow.receive.ReceiveKeyFromEscrowSharedServiceRequest;
import org.openscdp.pkidb.dao.KeyEscrowDAO;
import org.openscdp.pkidb.dto.KeyEscrowDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.holder.escrow.KeyEscrow;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveKeyFromEscrowAction
extends ServiceRequestSmartCardHSMAction {
    private final Logger logger = LoggerFactory.getLogger(ReceiveKeyFromEscrowAction.class);
    public static final String ACTION = "action.kess.receivefromescrow";
    protected ReceiveKeyFromEscrowSharedServiceRequest serviceRequest;
    private ReceiveKeyFromEscrowContent content;
    private String tokenPath;

    public ReceiveKeyFromEscrowAction(ReceiveKeyFromEscrowSharedServiceRequest serviceRequest) {
        super(ACTION, (ServiceRequest)serviceRequest);
        this.serviceRequest = serviceRequest;
        String lastSeenAt = serviceRequest.getBackendReceiverConnectedTo();
        if (lastSeenAt != null) {
            this.context = "@" + lastSeenAt;
        }
    }

    public String getKey() {
        return ACTION;
    }

    public ServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public boolean preFlightCheck() {
        this.content = this.serviceRequest.getContent();
        this.tokenPath = this.content.getTokenPath();
        return this.tokenPath != null;
    }

    protected void assertReady(SmartCardHSMProvider provider) throws OpenCardException, CertPathBuilderException {
        if (!this.preFlightCheck()) {
            throw new ServiceRequestActionException("Precondition for service request not fulfilled");
        }
        SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
        if (!service.getId().equals(this.tokenPath)) {
            throw new ServiceRequestActionException("Wrong Token presented");
        }
        try {
            if (provider.getSmartCardHSMCardService().getPasswordStatus(null, 1) != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                throw new ServiceRequestActionException("Token " + this.tokenPath + " is not authenticated");
            }
        }
        catch (CardServiceException | CardTerminalException e) {
            this.logger.error("Device error", e);
            throw new ServiceRequestActionException("Error while processing token " + this.tokenPath, e);
        }
    }

    public void unwrapKeys(SmartCardHSMProvider provider) {
        KeyEscrow keyEscrow = this.serviceRequest.getKeyEscrowHolder();
        byte[] keyDomainUID = keyEscrow.getSigner().getKeyDomain();
        XKEKKeyDomain receivingXKD = new XKEKKeyDomain(provider, keyDomainUID);
        this.setExchangeKey(receivingXKD);
        LinkedList<byte[]> importList = this.getKeysForUnwrap(receivingXKD);
        if (importList.size() > 0) {
            LinkedList keyEscrowChain = keyEscrow.getCertificateChain();
            receivingXKD.deriveXKEKWith(keyEscrowChain);
            for (byte[] wrappedKey : importList) {
                receivingXKD.unwrapKey(wrappedKey);
            }
        }
        receivingXKD.deleteEphemeralKey();
    }

    private LinkedList<byte[]> getKeysForUnwrap(XKEKKeyDomain receivingXKD) {
        List<Long> keysToImport = this.serviceRequest.getContent().keysToImport;
        List<String> keyblobs = this.serviceRequest.getContent().keyblobs;
        LinkedList<byte[]> importList = new LinkedList<byte[]>();
        try (Handle handle = PKIDMContext.getJDBI().open();){
            KeyEscrowDAO escrowDAO = (KeyEscrowDAO)handle.attach(KeyEscrowDAO.class);
            for (int i = 0; i < keysToImport.size(); ++i) {
                KeyEscrowDTO dto = escrowDAO.getKeyEscrow(keysToImport.get(i));
                if (receivingXKD.getKey(dto.getKeyId()) == null) {
                    byte[] keyblob = HexString.parseHexString((String)keyblobs.get(i));
                    importList.add(keyblob);
                    continue;
                }
                this.logger.debug("Key " + dto.getName() + " is already on the token");
            }
        }
        return importList;
    }

    private void setExchangeKey(XKEKKeyDomain receivingXKD) {
        CardVerifiableCertificate exchangeCert;
        try {
            SmartCardHSMCertificateChainTLV exchangeChain = this.serviceRequest.getExchangeChain();
            exchangeCert = exchangeChain.getCertificate();
        }
        catch (TLVEncodingException | CertificateException e) {
            throw new ServiceRequestActionException("Invalid exchange certificate chain", e);
        }
        SmartCardHSMPrivateKey exchangeKey = (SmartCardHSMPrivateKey)receivingXKD.getKey(exchangeCert.getSubjectPublicKeyIdentifier());
        receivingXKD.setEphemeralKey(exchangeKey);
    }

    @Override
    public JSONActionResult execute() {
        String lastSeenAt = this.serviceRequest.getBackendReceiverConnectedTo();
        if (lastSeenAt == null) {
            return this.getStatus();
        }
        return this.execute(this.serviceRequest.getContent().getTokenPath());
    }

    @Override
    public void execute(SmartCardHSMProvider provider) {
        try {
            this.assertReady(provider);
            this.unwrapKeys(provider);
            this.serviceRequest.setStatusInfo("Received key from escrow");
            this.serviceRequest.setLifeCycle(11);
            this.serviceRequest.setRoleId(null);
        }
        catch (ServiceRequestActionException srae) {
            throw srae;
        }
        catch (Exception e) {
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }
}

