/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.smartcardhsm;

import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class InitializeConfiguration {
    private byte[] options = new byte[]{0, 1};
    private byte[] initialPIN;
    private byte[] initCode;
    private byte retryCounter = (byte)3;
    private byte dkekShares = (byte)-1;
    private byte numberOfAuthenticationKeys = 0;
    private byte authenticationThreshold = 0;

    public InitializeConfiguration(byte[] initCode) {
        this.setInitializationCode(initCode);
    }

    public void setInitializationCode(byte[] code) {
        if (code.length != 8) {
            throw new IllegalArgumentException("The initialization code must have a length of 8 byte");
        }
        this.initCode = code;
    }

    public void setInitialPIN(byte[] pin) {
        if (pin.length < 6 || pin.length > 16) {
            throw new IllegalArgumentException("The initial PIN must range from 6 to 16 bytes");
        }
        this.initialPIN = pin;
    }

    public void setRetryCounterInitial(byte retryCounter) {
        if (retryCounter < 1 || retryCounter > 10) {
            throw new IllegalArgumentException("The retry counter must range from 1 to 10");
        }
        if (this.initialPIN != null) {
            if (this.initialPIN.length == 6 && retryCounter > 3) {
                throw new IllegalArgumentException("The SmartCard-HSM enforces a retry counter <= 3 for PIN length 6");
            }
            if (this.initialPIN.length == 7 && retryCounter > 5) {
                throw new IllegalArgumentException("The SmartCard-HSM enforces a retry counter <= 5 for PIN length 7");
            }
            if (this.initialPIN.length > 7) {
                throw new IllegalArgumentException("The SmartCard-HSM enforces a retry counter <= 10 for PIN length larger than 7");
            }
        }
        this.retryCounter = retryCounter;
    }

    public void setDKEKShares(byte keyshares) {
        this.dkekShares = keyshares;
    }

    public void setPublicKeyAuthenticationParameter(byte requiredPublicKeysForAuthentication, byte numberOfPublicKeys) {
        if (numberOfPublicKeys < 1 || numberOfPublicKeys > 90) {
            throw new IllegalArgumentException("The value of numberOfPublicKeys must range from 1 to 90");
        }
        if (requiredPublicKeysForAuthentication < 1 || requiredPublicKeysForAuthentication > numberOfPublicKeys) {
            throw new IllegalArgumentException("The value of requiredPublicKeysForAuthentication must range from 1 to numberOfPublicKeys");
        }
        this.numberOfAuthenticationKeys = numberOfPublicKeys;
        this.authenticationThreshold = requiredPublicKeysForAuthentication;
    }

    public void setResetRetryCounterMode(boolean enable) {
        this.options[1] = (byte)((this.options[1] & 0xFE) + (enable ? 1 : 0));
    }

    public void setTransportPINMode(boolean enable) {
        this.options[1] = (byte)((this.options[1] & 0xFD) + (enable ? 2 : 0));
    }

    public byte[] getCData() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(new PrimitiveTLV(128, this.options).getBytes());
            if (this.initialPIN != null) {
                bos.write(new PrimitiveTLV(129, this.initialPIN).getBytes());
            }
            bos.write(new PrimitiveTLV(130, this.initCode).getBytes());
            if (this.initialPIN != null) {
                bos.write(new PrimitiveTLV(145, new byte[]{this.retryCounter}).getBytes());
            }
            if (this.dkekShares != -1) {
                bos.write(new PrimitiveTLV(146, new byte[]{this.dkekShares}).getBytes());
            }
            if (this.numberOfAuthenticationKeys > 0) {
                PrimitiveTLV tlv = new PrimitiveTLV(147, new byte[]{this.numberOfAuthenticationKeys, this.authenticationThreshold});
                bos.write(tlv.getBytes());
            }
        }
        catch (TLVEncodingException | IOException exception) {
            // empty catch block
        }
        return bos.toByteArray();
    }
}

