/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pdf.service;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.openscdp.pdf.service.PDFGenerator;
import org.openscdp.pkidm.PKIDMContext;

public class PDFServletContextListener
implements ServletContextListener {
    public static final String ATTRIBUTE_PDFGEN = "PDFGEN";
    public static final String ATTRIBUTE_PKIDM = "PKIDM";

    public void contextInitialized(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        String url = ctx.getInitParameter("database.url");
        String user = ctx.getInitParameter("database.user");
        String password = ctx.getInitParameter("database.password");
        Jdbi jdbi = Jdbi.create((String)url, (String)user, (String)password);
        jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        PKIDMContext.setJDBI((Jdbi)jdbi);
        ctx.setAttribute(ATTRIBUTE_PKIDM, (Object)PKIDMContext.getInstance());
        String unoURL = ctx.getInitParameter("unoURL");
        String serverdir = ctx.getInitParameter("serverdir");
        String clientdir = ctx.getInitParameter("clientdir");
        PDFGenerator gen = new PDFGenerator(unoURL, serverdir, clientdir);
        ctx.setAttribute(ATTRIBUTE_PDFGEN, (Object)gen);
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        PDFGenerator gen = (PDFGenerator)ctx.getAttribute(ATTRIBUTE_PDFGEN);
        if (gen != null) {
            ctx.removeAttribute(ATTRIBUTE_PDFGEN);
        }
    }
}

