/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public class SmartCardHSMCertificateChainTLV
extends Sequence {
    private static Tag TAG_DICA_CERTIFICATE = new Tag(1, 64, true);
    private static Tag TAG_DEVICE_CERTIFICATE = new Tag(2, 64, true);
    private static Tag TAG_CERTIFICATE = new Tag(3, 64, true);

    public SmartCardHSMCertificateChainTLV(byte[] enc) throws TLVEncodingException {
        this(TLV.factory((byte[])enc));
    }

    public SmartCardHSMCertificateChainTLV(TLV tlv) throws TLVEncodingException {
        super(tlv);
    }

    public SmartCardHSMCertificateChainTLV(CardVerifiableCertificate dica, CardVerifiableCertificate device, CardVerifiableCertificate cert) throws CertificateEncodingException {
        this.add((TLV)new ObjectIdentifier("1.3.6.1.4.1.24991.4.3.1"));
        this.add((TLV)new PrimitiveTLV(TAG_DICA_CERTIFICATE, dica.getEncoded()));
        this.add((TLV)new PrimitiveTLV(TAG_DEVICE_CERTIFICATE, device.getEncoded()));
        this.add((TLV)new PrimitiveTLV(TAG_CERTIFICATE, cert.getEncoded()));
    }

    private CardVerifiableCertificate getCVC(Tag tag) throws CertificateException, TLVEncodingException {
        TLV tlv = this.findTag(tag, null);
        if (tlv == null) {
            throw new TLVEncodingException("Tag " + String.valueOf(tag) + " not found");
        }
        CardVerifiableCertificate cvc = new CardVerifiableCertificate(tlv.getValue());
        return cvc;
    }

    public CardVerifiableCertificate getCertificate() throws CertificateException, TLVEncodingException {
        return this.getCVC(TAG_CERTIFICATE);
    }

    public CardVerifiableCertificate getDICACertificate() throws CertificateException, TLVEncodingException {
        return this.getCVC(TAG_DICA_CERTIFICATE);
    }

    public CardVerifiableCertificate getDeviceCertificate() throws CertificateException, TLVEncodingException {
        return this.getCVC(TAG_DEVICE_CERTIFICATE);
    }
}

