/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkiapi;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkiapi.FormProcessingResult;
import org.openscdp.pkiapi.QuerySpec;
import org.openscdp.pkiapi.ServiceRequestCreationResult;
import org.openscdp.pkiapi.ServiceRequestResponse;
import org.openscdp.pkiapi.ServiceRequestResponseWithForm;
import org.openscdp.pkiapi.ServiceRequestTemplate;
import org.openscdp.pkicard.ServiceRequestCardAction;
import org.openscdp.pkidb.dao.FilteredQueryException;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestActionStates;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestCreationValidator;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactoryRegistry;
import org.openscdp.pkidm.servicerequest.ServiceRequestForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sr")
public class ServiceRequestResource {
    private final Logger logger = LoggerFactory.getLogger(ServiceRequestResource.class);

    @GET
    @Produces(value={"application/json"})
    public Response getServiceRequestList(@Context UriInfo info) {
        List list;
        this.logger.debug("GET /sr");
        MultivaluedMap params = info.getQueryParameters();
        QuerySpec qs = new QuerySpec((MultivaluedMap<String, String>)params);
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            try {
                list = dao.getServiceRequests(qs.getFilters(), qs.getOrderBy(), qs.getLimit(), qs.getOffset());
            }
            catch (FilteredQueryException e) {
                e.printStackTrace();
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                if (handle != null) {
                    handle.close();
                }
                return response;
            }
        }
        ArrayList<ServiceRequestResponse> rsp = new ArrayList<ServiceRequestResponse>(list.size());
        for (ServiceRequestDTO dto : list) {
            rsp.add(new ServiceRequestResponse(dto));
        }
        return Response.ok(rsp).build();
    }

    @GET
    @Path(value="/involved")
    @Produces(value={"application/json"})
    public Response getInvolvedServiceRequestList(@Context UriInfo info, @HeaderParam(value="UserId") Long userId) {
        List list;
        this.logger.debug("GET /sr/involved");
        MultivaluedMap params = info.getQueryParameters();
        QuerySpec qs = new QuerySpec((MultivaluedMap<String, String>)params);
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            try {
                list = dao.getInvolvedServiceRequests(userId, qs.getFilters(), qs.getOrderBy(), qs.getLimit(), qs.getOffset());
            }
            catch (FilteredQueryException e) {
                e.printStackTrace();
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                if (handle != null) {
                    handle.close();
                }
                return response;
            }
        }
        ArrayList<ServiceRequestResponse> rsp = new ArrayList<ServiceRequestResponse>(list.size());
        for (ServiceRequestDTO dto : list) {
            rsp.add(new ServiceRequestResponse(dto));
        }
        return Response.ok(rsp).build();
    }

    @GET
    @Path(value="/count")
    @Produces(value={"application/json"})
    public Response getServiceRequestCount(@Context UriInfo info) {
        this.logger.debug("GET /sr/count");
        MultivaluedMap params = info.getQueryParameters();
        QuerySpec qs = new QuerySpec((MultivaluedMap<String, String>)params);
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            try {
                Long count = dao.getServiceRequestCount(qs.getFilters());
                Response response = Response.ok((Object)count).build();
                return response;
            }
            catch (FilteredQueryException e) {
                Response response;
                block9: {
                    e.printStackTrace();
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    if (handle == null) break block9;
                    handle.close();
                }
                return response;
            }
        }
    }

    @GET
    @Path(value="/involved/count")
    @Produces(value={"application/json"})
    public Response getInvolvedServiceRequestCount(@Context UriInfo info, @HeaderParam(value="UserId") Long userId) {
        this.logger.debug("GET /sr/involved/count");
        MultivaluedMap params = info.getQueryParameters();
        QuerySpec qs = new QuerySpec((MultivaluedMap<String, String>)params);
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            try {
                Long count = dao.getInvolvedServiceRequestCount(userId, qs.getFilters());
                Response response = Response.ok((Object)count).build();
                return response;
            }
            catch (FilteredQueryException e) {
                Response response;
                block9: {
                    e.printStackTrace();
                    response = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                    if (handle == null) break block9;
                    handle.close();
                }
                return response;
            }
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getServiceRequest(@PathParam(value="id") Long id, @HeaderParam(value="UserId") Long userId) {
        this.logger.debug("GET /sr/" + id);
        ServiceRequest sr = this.loadServiceRequest(id, userId);
        ServiceRequestResponse rsp = new ServiceRequestResponse(sr);
        return Response.ok((Object)rsp).build();
    }

    @GET
    @Path(value="/{id}/form")
    @Produces(value={"application/json"})
    public Response getServiceRequestForm(@PathParam(value="id") Long id, @HeaderParam(value="UserId") Long userId) {
        this.logger.debug("GET /sr/" + id + "/form");
        ServiceRequest sr = this.loadServiceRequest(id, userId);
        if (!(sr instanceof ServiceRequestForm)) {
            this.logger.error("Forms not supported by service request");
            throw new NotSupportedException();
        }
        ServiceRequestResponseWithForm rsp = new ServiceRequestResponseWithForm(sr);
        return Response.ok((Object)rsp).build();
    }

    @POST
    @Path(value="/{id}/action")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postAction(@Context HttpServletRequest req, @PathParam(value="id") Long id, @HeaderParam(value="UserId") Long userId, JSONAction action) {
        this.logger.debug("POST /sr/" + id + "/action");
        ServiceRequest sr = this.loadServiceRequest(id, userId);
        ServiceRequestAction sra = sr.getActionFor(action);
        if (sra == null) {
            if (action.action.equals("action.save")) {
                FormProcessingResult rsp = new FormProcessingResult(ServiceRequestActionStates.COMPLETED.toString(), "Save action ignored", sr);
                return Response.ok((Object)((Object)rsp)).build();
            }
            this.logger.error("Action " + action.action + " not supported for service request");
            FormProcessingResult rsp = new FormProcessingResult(ServiceRequestActionStates.FAILED.toString(), "Action " + action.action + " is not supported or currently not possible", sr);
            return Response.ok((Object)((Object)rsp)).build();
        }
        if (sr instanceof ServiceRequestForm && action.args != null && !action.args.isEmpty()) {
            ServiceRequestForm srf = (ServiceRequestForm)sr;
            if (!srf.processForm(action)) {
                FormProcessingResult rsp = new FormProcessingResult(ServiceRequestActionStates.FAILED.toString(), "Input field validation", sr);
                return Response.ok((Object)((Object)rsp)).build();
            }
            sra = sr.getActionFor(action);
            if (sra == null) {
                this.logger.error("Action " + action.action + " is no longer supported after form update");
                FormProcessingResult rsp = new FormProcessingResult(ServiceRequestActionStates.FAILED.toString(), "Action " + action.action + " is no longer supported after form update", sr);
                return Response.ok((Object)((Object)rsp)).build();
            }
        }
        if (sra instanceof ServiceRequestCardAction) {
            HttpSession session = req.getSession();
            session.setAttribute("ServiceRequestCardAction", (Object)sra);
        }
        return Response.ok((Object)sra.execute()).build();
    }

    @GET
    @Path(value="/{id}/action")
    @Produces(value={"application/json"})
    public Response getAction(@Context HttpServletRequest req, @PathParam(value="id") Long id) {
        this.logger.debug("GET /sr/" + id + "/action");
        HttpSession session = req.getSession(false);
        if (session == null) {
            this.logger.error("No active session for service request " + id);
            throw new NotFoundException();
        }
        ServiceRequestAction sra = (ServiceRequestAction)session.getAttribute("ServiceRequestCardAction");
        if (sra == null || !(sra instanceof ServiceRequestCardAction)) {
            this.logger.error("No active action for service request " + id);
            throw new NotFoundException();
        }
        ServiceRequestCardAction srca = (ServiceRequestCardAction)sra;
        return Response.ok((Object)srca.getStatus()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postCreate(@Context UriInfo uriInfo, @HeaderParam(value="UserId") Long userId, ServiceRequestTemplate template) {
        ServiceRequestCreationValidator srv;
        this.logger.debug("POST /sr");
        ServiceRequestDTO dto = template.asDTO();
        ServiceRequestFactoryRegistry reg = PKIDMContext.getServiceRequestFactoryRegistry();
        if (!reg.isSupported(dto)) {
            String detail = "Service request " + dto.getProcess() + " not support by API";
            this.logger.error(detail);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new JSONActionResult(ServiceRequestActionStates.FAILED, detail)).build();
        }
        ServiceRequest sr = reg.getByDTO(dto);
        if (!(sr instanceof ServiceRequestCreationValidator)) {
            String detail = "Service request " + dto.getProcess() + " does not support generic generation API";
            this.logger.error(detail);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new JSONActionResult(ServiceRequestActionStates.FAILED, detail)).build();
        }
        if (userId != null) {
            sr.setUserId(userId);
        }
        if (!(srv = (ServiceRequestCreationValidator)sr).validateCreation()) {
            Object detail = dto.getState();
            if (detail == null) {
                detail = "Service request " + dto.getProcess() + " validator denied creation";
            }
            this.logger.error((String)detail);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new JSONActionResult(ServiceRequestActionStates.FAILED, (String)detail)).build();
        }
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dao.create(dto);
        }
        URI uri = uriInfo.getAbsolutePathBuilder().path(Long.toString(dto.getId())).build(new Object[0]);
        return Response.created((URI)uri).entity((Object)new ServiceRequestCreationResult(ServiceRequestActionStates.COMPLETED, "Service request created", dto.getId())).build();
    }

    private ServiceRequest loadServiceRequest(Long id, Long userId) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            ServiceRequestDTO dto = dao.getServiceRequest(id);
            if (dto == null) {
                this.logger.error("Service request " + id + " not found");
                throw new NotFoundException();
            }
            ServiceRequestFactoryRegistry reg = PKIDMContext.getServiceRequestFactoryRegistry();
            if (!reg.isSupported(dto)) {
                this.logger.error("Service request " + id + " not support by API");
                throw new NotSupportedException();
            }
            ServiceRequest sr = reg.getByDTO(dto);
            if (userId != null) {
                sr.setUserId(userId);
            }
            ServiceRequest serviceRequest = sr;
            return serviceRequest;
        }
    }
}

