/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.jdbi;

import java.util.List;
import javax.naming.ConfigurationException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dto.AssignedRoleDTO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.ConfigurationDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.RequestDTO;
import org.openscdp.pkidb.dto.RoleDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.ServiceRequestStateDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidb.dto.TokenActionDTO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidb.jdbi.JdbiFactory;

public class JDBIExample {
    String userName = "foo";
    String password = "foo";
    String url = "jdbc:mariadb://localhost:3306/pkidb";
    Jdbi jdbi;

    public JDBIExample() {
        try {
            this.jdbi = JdbiFactory.getInstance();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void getHolder() {
        this.jdbi.registerRowMapper(BeanMapper.factory(HolderDTO.class));
        this.jdbi.registerRowMapper(BeanMapper.factory(ServiceRequestDTO.class));
        List holders = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from Holder").mapToBean(HolderDTO.class).list());
        System.out.println(holders);
    }

    public void getServiceRequest() {
        this.jdbi.registerRowMapper(BeanMapper.factory(ServiceRequestDTO.class));
        List serviceRequests = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from ServiceRequest").mapToBean(ServiceRequestDTO.class).list());
        System.out.println(serviceRequests);
    }

    public void getAssignedRoles() {
        this.jdbi.registerRowMapper(BeanMapper.factory(AssignedRoleDTO.class));
        List list = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from AssignedRole").mapToBean(AssignedRoleDTO.class).list());
        System.out.println(list);
    }

    public void getCertificates() {
        this.jdbi.registerRowMapper(BeanMapper.factory(CertificateDTO.class));
        List certificates = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from Certificate").mapToBean(CertificateDTO.class).list());
        System.out.println(certificates);
    }

    public void getConfigurations() {
        this.jdbi.registerRowMapper(BeanMapper.factory(ConfigurationDTO.class));
        List list = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from Configuration").mapToBean(ConfigurationDTO.class).list());
        System.out.println(list);
    }

    public void getRequests() {
        this.jdbi.registerRowMapper(BeanMapper.factory(RequestDTO.class));
        List list = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from Request").mapToBean(RequestDTO.class).list());
        System.out.println(list);
    }

    public void getRoles() {
        this.jdbi.registerRowMapper(BeanMapper.factory(RoleDTO.class));
        List list = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from Role").mapToBean(RoleDTO.class).list());
        System.out.println(list);
    }

    public void getServiceRequestStates() {
        this.jdbi.registerRowMapper(BeanMapper.factory(ServiceRequestStateDTO.class));
        List list = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from ServiceRequestState").mapToBean(ServiceRequestStateDTO.class).list());
        System.out.println(list);
    }

    public void getSigners() {
        this.jdbi.registerRowMapper(BeanMapper.factory(SignerDTO.class));
        List list = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from Signer").mapToBean(SignerDTO.class).list());
        System.out.println(list);
    }

    public void getToken() {
        this.jdbi.registerRowMapper(BeanMapper.factory(TokenDTO.class));
        List list = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from Token").mapToBean(TokenDTO.class).list());
        System.out.println(list);
    }

    public void getTokenAction() {
        this.jdbi.registerRowMapper(BeanMapper.factory(TokenActionDTO.class));
        List list = (List)this.jdbi.withHandle(handle -> handle.createQuery("select * from TokenAction").mapToBean(TokenActionDTO.class).list());
        System.out.println(list);
    }

    public static void main(String[] args) {
        JDBIExample e = new JDBIExample();
        e.getAssignedRoles();
        e.getCertificates();
        e.getConfigurations();
        e.getHolder();
        e.getRequests();
        e.getRoles();
        e.getServiceRequest();
        e.getServiceRequestStates();
        e.getSigners();
        e.getToken();
        e.getTokenAction();
        ServiceRequestDTO sr = new ServiceRequestDTO();
        sr.setProcess("ESTCertificateServiceRequest");
        sr.setTitle("Request Certificate");
        sr.setState("Created");
        sr.setLifecycle(1);
        try (Handle handle = e.jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            System.out.println(dao.getServiceRequest(sr.getId()));
            SubjectDAO subjectDAO = (SubjectDAO)handle.attach(SubjectDAO.class);
            List<SubjectDTO> estSubjects = subjectDAO.listSubjects("ESTServer", SubjectDTO.TYPE_TRUST_CENTER);
            System.out.println(estSubjects);
            List<SubjectDTO> subjects = subjectDAO.listSubjects(SubjectDTO.TYPE_TRUST_CENTER);
            System.out.println(subjects);
        }
        e.getServiceRequest();
        e.getHolder();
    }
}

