/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMKeyAgreement
extends KeyAgreementSpi {
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMKeyAgreement.class);
    private SmartCardHSMCardService schsm;
    private SmartCardHSMKey privateKey;
    private ECParameterSpec ecparam;
    private boolean finishedKeyAgreement;
    private byte[] secret;

    public SmartCardHSMKeyAgreement(SmartCardHSMProvider provider, String algorithm) {
        this.schsm = provider.getSmartCardHSMCardService();
        if (!provider.isVerified()) {
            throw new ProviderException("Login required.");
        }
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        byte[] encodedECP = null;
        try {
            encodedECP = this.schsm.performECCDH(this.privateKey, this.getPublicKeyComponents(key));
        }
        catch (CardServiceException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardTerminalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        int size = (encodedECP.length - 1) / 2;
        byte[] x = new byte[size];
        byte[] y = new byte[size];
        System.arraycopy(encodedECP, 1, x, 0, size);
        System.arraycopy(encodedECP, 1 + size, y, 0, size);
        ECPoint ecp = new ECPoint(new BigInteger(x), new BigInteger(y));
        PublicKey newKey = null;
        try {
            ECPublicKeySpec spec = new ECPublicKeySpec(ecp, this.ecparam);
            KeyFactory kf = KeyFactory.getInstance("EC");
            newKey = kf.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (InvalidKeySpecException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        if (lastPhase) {
            this.finishedKeyAgreement = true;
            this.secret = encodedECP;
        }
        return newKey;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.finishedKeyAgreement) {
            throw new IllegalStateException("Can't genereate secret when this isn't the last phase.");
        }
        return this.secret;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (!this.finishedKeyAgreement) {
            throw new IllegalStateException("Can't genereate secret when this isn't the last phase.");
        }
        if (this.secret.length + offset > sharedSecret.length) {
            throw new ShortBufferException("The input buffer is too short");
        }
        System.arraycopy(this.secret, 0, sharedSecret, offset, this.secret.length);
        return sharedSecret.length;
    }

    @Override
    protected void engineInit(Key key, SecureRandom rnd) throws InvalidKeyException {
        if (!(key instanceof SmartCardHSMKey)) {
            throw new InvalidKeyException("Key must be type of SmartCardHSMECKey");
        }
        this.privateKey = (SmartCardHSMKey)key;
        BigInteger prime = new BigInteger("A9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377", 16);
        ECFieldFp field = new ECFieldFp(prime);
        BigInteger a = new BigInteger("7D5A0975FC2C3057EEF67530417AFFE7FB8055C126DC5C6CE94A4B44F330B5D9", 16);
        BigInteger b = new BigInteger("26DC5C6CE94A4B44F330B5D9BBD77CBF958416295CF7E1CE6BCCDC18FF8C07B6", 16);
        EllipticCurve curve = new EllipticCurve(field, a, b);
        BigInteger x = new BigInteger("8BD2AEB9CB7E57CB2C4B482FFC81B7AFB9DE27E1E3BD23C23A4453BD9ACE3262", 16);
        BigInteger y = new BigInteger("547EF835C3DAC4FD97F8461A14611DC9C27745132DED8E545C1D54C72F046997", 16);
        ECPoint g = new ECPoint(x, y);
        BigInteger n = new BigInteger("A9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7", 16);
        int h = 1;
        this.ecparam = new ECParameterSpec(curve, g, n, h);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec param, SecureRandom rnd) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SmartCardHSMECKey)) {
            throw new InvalidKeyException("Key must be type of SmartCardHSMECKey");
        }
        this.privateKey = (SmartCardHSMECKey)key;
        if (!(param instanceof ECParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Parameter must be type of ECParameterSpec");
        }
        this.ecparam = (ECParameterSpec)param;
    }

    private byte[] getPublicKeyComponents(Key key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            ECPublicKey ecKey = (ECPublicKey)key;
            ECPoint p = ecKey.getW();
            BigInteger x = p.getAffineX();
            BigInteger y = p.getAffineY();
            ByteArrayOutputStream basePointG = new ByteArrayOutputStream();
            basePointG.write(4);
            try {
                basePointG.write(SmartCardHSMKeyAgreement.unsignedBigIntegerToByteArray(x, 256));
                basePointG.write(SmartCardHSMKeyAgreement.unsignedBigIntegerToByteArray(y, 256));
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            return basePointG.toByteArray();
        }
        throw new InvalidKeyException("Key must be type of ECPublicKey");
    }

    protected static byte[] unsignedBigIntegerToByteArray(BigInteger bi, int size) {
        byte[] s = bi.toByteArray();
        size = (size >> 3) + ((size & 7) == 0 ? 0 : 1);
        byte[] d = new byte[size];
        int od = size - s.length;
        int os = 0;
        if (od < 0) {
            if (od < -1 || s[0] != 0) {
                throw new IllegalArgumentException("Size mismatch converting big integer to byte array");
            }
            os = -od;
            od = 0;
        }
        System.arraycopy(s, os, d, od, size -= od);
        return d;
    }
}

