/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc.path;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificateGenerator;
import de.cardcontact.opencard.eac.cvc.CVCertificateRequestGenerator;
import de.cardcontact.opencard.eac.cvc.CertificateEffectiveDate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.ECPublicKeyTLV;
import de.cardcontact.opencard.eac.cvc.PublicKeyTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.time.LocalDate;
import java.util.LinkedList;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.cvc.CVCCAPolicy;
import org.openscdp.pkidm.cvc.CryptoProvider;
import org.openscdp.pkidm.cvc.path.CVCertificateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVCCA {
    private final Logger logger = LoggerFactory.getLogger(CVCCA.class);
    private LinkedList<CardVerifiableCertificate> caChain;
    private CVCertificateStore store;
    private CryptoProvider provider;
    private String path;

    public CVCCA(CVCertificateStore store, String path, CryptoProvider provider) {
        this.store = store;
        this.path = path;
        this.provider = provider;
    }

    public void setProvider(CryptoProvider provider) {
        this.provider = provider;
    }

    public CardVerifiableCertificate getCACert() throws Exception {
        if (this.getCertificateChain().isEmpty()) {
            return null;
        }
        return this.getCertificateChain().getLast();
    }

    public LinkedList<CardVerifiableCertificate> getCertificateChain() throws Exception {
        if (this.caChain == null) {
            LinkedList<CardVerifiableCertificate> chain = new LinkedList<CardVerifiableCertificate>();
            String[] paths = this.path.split("/");
            Object path = "";
            for (int i = 1; i < paths.length; ++i) {
                CertificateDTO dto = this.store.getCurrentCertificate((String)(path = (String)path + "/" + paths[i]));
                if (dto == null) {
                    this.logger.warn("CVCCA " + this.path + " is not operational");
                    return chain;
                }
                CardVerifiableCertificate cvc = new CardVerifiableCertificate(dto.getBytes());
                PublicKey pub = i == 1 ? cvc.getPublicKey() : chain.get(i - 2).getPublicKey();
                cvc.verify(pub, "SHA256withECDSA", "BC");
                chain.add(cvc);
            }
            this.caChain = chain;
        }
        return this.caChain;
    }

    public String getPath() {
        return this.path;
    }

    private String getPath(CardVerifiableCertificate cvc) {
        String path = this.path + "/" + cvc.getCertificateHolderReference().getHolder();
        return path;
    }

    private PrivateKey getPrivateKey(CertificateHolderReference chr) throws Exception {
        SignerDTO signer = this.store.getSigner(this.path, chr);
        if (signer.getKeyblob() != null) {
            return this.provider.getPrivateKey(signer.getKeyblob());
        }
        return this.provider.getPrivateKey(signer.getKeyId(), signer.getKeyDomain(), signer.getKeyblob());
    }

    public CardVerifiableCertificate generateRequest(CertificationAuthorityReference car, AlgorithmParameterSpec params) throws Exception {
        CertificateHolderReference chr = new CertificateHolderReference(this.getHolder().getName() + "00000");
        String alias = chr.toString();
        KeyPair kp = this.provider.generateKeyPair(params, alias);
        byte[] keyblob = null;
        if (kp.getPrivate().getEncoded() != null) {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
            keyblob = privateKeyInfo.getEncoded();
        }
        byte[] keyId = alias.getBytes();
        this.store.storeSigner(this.path, chr.getHolder(), keyId, null, keyblob);
        CVCertificateRequestGenerator reqGen = new CVCertificateRequestGenerator(this.provider.getProvider());
        reqGen.setCertificateHolderReference(chr);
        reqGen.setCertificationAuthorityReference(car);
        reqGen.setPublicKey(kp.getPublic());
        CVCertificate asn1Req = reqGen.generate(kp.getPrivate());
        CardVerifiableCertificate req = new CardVerifiableCertificate(asn1Req.getBytes());
        this.store.storeRequest(this.path, asn1Req.getBytes(), keyId);
        return req;
    }

    private boolean isRoot() {
        return this.path.indexOf("/", 1) == -1;
    }

    private CardVerifiableCertificate generateCertificate(CardVerifiableCertificate req, CVCCAPolicy policy) throws Exception {
        ECPublicKeyTLV ecPub;
        PublicKey verifyingKey;
        CertificationAuthorityReference car;
        CVCertificateGenerator gen = new CVCertificateGenerator(this.provider.getProvider());
        CertificateEffectiveDate notBefore = new CertificateEffectiveDate(LocalDate.now());
        gen.setCertificateEffectiveDate(notBefore);
        LocalDate notAfter = LocalDate.now().plusDays(policy.getCertificateValidityDays());
        CertificateExpirationDate cxd = new CertificateExpirationDate(notAfter);
        gen.setCertificateExpirationDate(cxd);
        if (this.getCACert() != null) {
            car = new CertificationAuthorityReference(this.getCACert().getCertificateHolderReference().toString());
            verifyingKey = this.getCACert().getPublicKey();
        } else {
            if (!this.isRoot()) {
                throw new Exception("CA Certificate not found");
            }
            this.logger.debug("Generate self-signed CVC");
            car = new CertificationAuthorityReference(req.getCertificateHolderReference().toString());
            verifyingKey = req.getPublicKey();
        }
        gen.setCertificationAuthorityReference(car);
        gen.setCertificateHolderReference(req.getCertificateHolderReference());
        gen.setCertificateHolderAuthorizationTemplate(policy.getChat());
        PublicKeyTLV pubKeyTLV = req.getCVCertificate().getCertificateBody().getPublicKeyTLV();
        PublicKey pubKey = null;
        if (pubKeyTLV instanceof ECPublicKeyTLV && !(ecPub = (ECPublicKeyTLV)pubKeyTLV).hasDomainParameter()) {
            ECParameterSpec domain = this.getCertificateChain().getFirst().getECParameterSpec();
            pubKey = req.getPublicKey((AlgorithmParameterSpec)domain);
        }
        if (pubKey == null) {
            pubKey = req.getPublicKey();
        }
        gen.setPublicKey(pubKey, policy.getPublicKeyOID());
        gen.withDomainParameter(policy.isIncludeDomainParameter());
        CertificateHolderReference signingKeyCHR = new CertificateHolderReference(car.toString());
        PrivateKey prk = this.getPrivateKey(signingKeyCHR);
        String signAlgo = CardVerifiableCertificate.signAlgoForOID((ObjectIdentifier)policy.getPublicKeyOID());
        CVCertificate tlv = signAlgo != null ? gen.generate(prk, signAlgo) : gen.generate(prk);
        CardVerifiableCertificate cvc = new CardVerifiableCertificate(tlv.getBytes());
        cvc.verify(verifyingKey);
        return cvc;
    }

    private HolderDTO getHolder() throws Exception {
        return this.store.getOrCreateHolder(this.path);
    }

    public CertificateHolderReference getNextCHR(long offset, String prefix) throws Exception {
        return this.store.getNextCHR(this.getHolder(), offset, prefix);
    }

    public CardVerifiableCertificate issueCertificate(CardVerifiableCertificate req, CVCCAPolicy policy, Long srId) throws Exception {
        CardVerifiableCertificate cvc = this.generateCertificate(req, policy);
        String path = this.getPath(cvc);
        this.store.storeCertificate(path, cvc, true, srId);
        return cvc;
    }

    public CardVerifiableCertificate issueSelfSignedCertificate(CardVerifiableCertificate req, CVCCAPolicy policy, Long srId) throws Exception {
        CardVerifiableCertificate cvc = this.generateCertificate(req, policy);
        String path = "/" + cvc.getCertificateHolderReference().getHolder();
        this.store.storeCertificate(path, cvc, true, srId);
        return cvc;
    }
}

