/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc.importer;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import java.security.cert.CertPathBuilderException;
import java.util.List;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.holder.CVCertificateHolder;

public class TokenCertificateImporter {
    private String seenAt;

    public TokenCertificateImporter(String seenAt) {
        this.seenAt = seenAt;
    }

    public static long determineType(int type, int version, int platform) throws CardTerminalException, CardServiceException {
        long tokenType = type << 24;
        tokenType += (long)(platform << 16);
        return tokenType += (long)version;
    }

    public void importDeviceChain(CardVerifiableCertificate[] chain, Long type) throws OpenCardException, CertPathBuilderException {
        CardVerifiableCertificate srcaCert = chain[2];
        CardVerifiableCertificate dicaCert = chain[1];
        CardVerifiableCertificate deviceCert = chain[0];
        String path = "/" + srcaCert.getCertificateHolderReference().getHolder() + "/" + dicaCert.getCertificateHolderReference().getHolder() + "/" + deviceCert.getCertificateHolderReference().getHolder();
        TokenDTO token = this.findTokenDTO(path);
        if (token == null || token.getCertId() == null) {
            CertificateDTO srca = this.importCertificate(srcaCert, null, "SRCA");
            CertificateDTO dica = this.importCertificate(dicaCert, srca.getHolderId(), "DICA");
            CertificateDTO deviceCertDTO = this.importCertificate(deviceCert, dica.getHolderId(), null);
            if (token == null) {
                this.insertToken(path, deviceCertDTO.getId(), type);
            } else {
                this.updateToken(path, deviceCertDTO.getId(), type);
            }
        } else {
            this.updateToken(path, token.getCertId(), type);
        }
    }

    private TokenDTO findTokenDTO(String path) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            TokenDAO tokenDAO = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO tokenDTO = tokenDAO.getToken(path);
            return tokenDTO;
        }
    }

    private CertificateDTO findCertificateDTO(Long holderId, CardVerifiableCertificate cvc) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            List certs = certDAO.getCertificateBySerial(holderId, cvc.getCertificateHolderReference().toString());
            if (certs.size() > 1) {
                throw new RuntimeException("Certificate chain is not distinct for holder " + holderId);
            }
            if (certs.isEmpty()) {
                CertificateDTO certificateDTO = null;
                return certificateDTO;
            }
            CertificateDTO certificateDTO = (CertificateDTO)certs.get(0);
            return certificateDTO;
        }
    }

    public CertificateDTO importCertificate(CardVerifiableCertificate cvc, Long parentId, String holderType) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            HolderDTO holderDTO;
            HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
            String name = cvc.getCertificateHolderReference().getHolder();
            Long holderId = parentId == null ? holderDAO.getRootHolderId(1, name) : holderDAO.getHolderId(1, parentId, name);
            boolean makeCurrent = false;
            if (holderId == null) {
                holderDTO = new HolderDTO();
                if (parentId != null) {
                    holderDTO.setParentId(parentId);
                }
                holderDTO.setCertificateType(1);
                if (holderType != null) {
                    holderDTO.setType(holderType);
                }
                holderDTO.setName(name);
                holderDAO.create(holderDTO);
                makeCurrent = true;
            } else {
                CertificateDTO certDTO = this.findCertificateDTO(holderId, cvc);
                if (certDTO != null) {
                    CertificateDTO certificateDTO = certDTO;
                    return certificateDTO;
                }
                holderDTO = holderDAO.getHolder(holderId);
            }
            CVCertificateHolder holder = new CVCertificateHolder(holderDTO);
            Long certId = holder.storeCertificate(cvc, makeCurrent, null);
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            CertificateDTO certificateDTO = certDAO.getCertificate(certId);
            return certificateDTO;
        }
    }

    public void updateToken(String path, Long certId, Long type) throws OpenCardException, CertPathBuilderException {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            TokenDAO tokenDAO = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO token = new TokenDTO();
            token.setPath(path);
            token.setLastSeenAt(this.seenAt);
            token.setType(type);
            token.setCertId(certId);
            tokenDAO.updateMetaData(token);
        }
    }

    public void insertToken(String path, Long certId, Long type) throws OpenCardException, CertPathBuilderException {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            TokenDAO tokenDAO = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO token = new TokenDTO();
            token.setPath(path);
            token.setLastSeenAt(this.seenAt);
            token.setType(type);
            token.setCertId(certId);
            tokenDAO.create(token);
        }
    }
}

