/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.remoteclient;

import de.cardcontact.opencard.service.remoteclient.RemoteCardSpec;
import de.cardcontact.tlv.HexString;
import opencard.core.terminal.APDU;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;

public class RemoteProtocolUnit {
    private Action action;
    private int id;
    private int ttc;
    private String message;
    private Object payload;

    public RemoteProtocolUnit(Action action) {
        this.action = action;
    }

    public RemoteProtocolUnit(Action action, int id, String message, int ttc) {
        this.id = id;
        this.message = message;
        this.action = action;
        this.ttc = ttc;
    }

    public RemoteProtocolUnit(Action action, int id, String message) {
        this(action, id, message, 0);
    }

    public RemoteProtocolUnit(CommandAPDU com) {
        this.action = Action.APDU;
        this.payload = com;
    }

    public RemoteProtocolUnit(ResponseAPDU res) {
        this.action = Action.APDU;
        this.payload = res;
    }

    public RemoteProtocolUnit(CardID cardID) {
        this(new RemoteCardSpec(cardID));
    }

    public RemoteProtocolUnit(RemoteCardSpec rcs) {
        this.action = Action.RESET;
        this.payload = rcs;
    }

    public Object getPayload() {
        return this.payload;
    }

    public Action getAction() {
        return this.action;
    }

    public int getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public int getTimeToCompletion() {
        return this.ttc;
    }

    public boolean isAPDU() {
        return this.action == Action.APDU;
    }

    public boolean isRESET() {
        return this.action == Action.RESET;
    }

    public boolean isNOTIFY() {
        return this.action == Action.NOTIFY;
    }

    public boolean isClosing() {
        return this.action == Action.CLOSE;
    }

    public String toString() {
        Object str = "Unknown";
        switch (this.action) {
            case APDU: {
                APDU apdu = (APDU)this.payload;
                str = "APDU " + HexString.hexifyByteArray(apdu.getBytes());
                break;
            }
            case RESET: {
                if (this.payload == null) {
                    str = "RESET";
                    break;
                }
                str = "ATR " + ((RemoteCardSpec)this.payload).toString();
                break;
            }
            case NOTIFY: {
                str = "NOTIFY " + this.message + "(" + this.id + "," + this.ttc + ")";
                break;
            }
            case CLOSE: {
                str = "CLOSE";
            }
        }
        return str;
    }

    public static enum Action {
        APDU,
        RESET,
        NOTIFY,
        CLOSE;

    }
}

