/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;

public class LongCodec
implements Codec<Long> {
    public static final LongCodec INSTANCE = new LongCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.FLOAT, new DataType[]{DataType.DOUBLE, DataType.OLDDECIMAL, DataType.VARCHAR, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.BIT, DataType.YEAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    public static long parseNotEmpty(ReadableByteBuf buf, int length) {
        boolean negate = false;
        int idx = 0;
        long result = 0L;
        if (length > 0 && buf.getByte() == 45) {
            negate = true;
            buf.skip();
        }
        while (true) {
            int n = ++idx;
            ++idx;
            if (n >= length) break;
            result = result * 10L + (long)buf.readByte() - 48L;
        }
        if (negate) {
            result = -1L * result;
        }
        return result;
    }

    @Override
    public String className() {
        return Long.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Integer.TYPE || type.isAssignableFrom(Long.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Long;
    }

    @Override
    public Long decodeText(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeTextLong(buffer, length, column);
    }

    public long decodeTextLong(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        switch (column.getType()) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case YEAR: {
                return LongCodec.parseNotEmpty(buf, length);
            }
            case BIGINT: {
                if (column.isSigned()) {
                    return LongCodec.parseNotEmpty(buf, length);
                }
                BigInteger val = new BigInteger(buf.readAscii(length));
                try {
                    return val.longValueExact();
                }
                catch (ArithmeticException ae) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", val));
                }
            }
            case BIT: {
                long result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                return result;
            }
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: {
                String str2 = buf.readAscii(length);
                try {
                    return new BigDecimal(str2).setScale(0, RoundingMode.DOWN).longValueExact();
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", str2));
                }
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                String str = buf.readString(length);
                try {
                    return new BigInteger(str).longValueExact();
                }
                catch (NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", str));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{column.getType()}));
    }

    @Override
    public Long decodeBinary(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeBinaryLong(buffer, length, column);
    }

    public long decodeBinaryLong(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        switch (column.getType()) {
            case BIT: {
                long result = 0L;
                for (int i = 0; i < length; ++i) {
                    byte b = buf.readByte();
                    result = (result << 8) + (long)(b & 0xFF);
                }
                return result;
            }
            case TINYINT: {
                if (!column.isSigned()) {
                    return buf.readUnsignedByte();
                }
                return buf.readByte();
            }
            case SMALLINT: 
            case YEAR: {
                if (!column.isSigned()) {
                    return buf.readUnsignedShort();
                }
                return buf.readShort();
            }
            case MEDIUMINT: {
                long l = column.isSigned() ? (long)buf.readMedium() : (long)buf.readUnsignedMedium();
                buf.skip();
                return l;
            }
            case INTEGER: {
                if (!column.isSigned()) {
                    return buf.readUnsignedInt();
                }
                return buf.readInt();
            }
            case BIGINT: {
                if (column.isSigned() || (buf.getByte(buf.pos() + 7) & 0x80) == 0) {
                    return buf.readLong();
                }
                byte[] bb = new byte[8];
                for (int i = 7; i >= 0; --i) {
                    bb[i] = buf.readByte();
                }
                BigInteger val = new BigInteger(1, bb);
                try {
                    return val.longValueExact();
                }
                catch (ArithmeticException ae) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", val));
                }
            }
            case FLOAT: {
                return (long)buf.readFloat();
            }
            case DOUBLE: {
                return (long)buf.readDouble();
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{column.getType()}));
                }
            }
            case DECIMAL: 
            case VARCHAR: 
            case VARSTRING: 
            case STRING: 
            case OLDDECIMAL: {
                String str = buf.readString(length);
                try {
                    return new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Long", str));
                }
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeLong((Long)value);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.BIGINT.get();
    }
}

