/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.server;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.impl.StandardReadableByteBuf;
import org.mariadb.jdbc.message.ServerMessage;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.BigDecimalCodec;
import org.mariadb.jdbc.plugin.codec.BigIntegerCodec;
import org.mariadb.jdbc.plugin.codec.BlobCodec;
import org.mariadb.jdbc.plugin.codec.BooleanCodec;
import org.mariadb.jdbc.plugin.codec.ByteArrayCodec;
import org.mariadb.jdbc.plugin.codec.DateCodec;
import org.mariadb.jdbc.plugin.codec.DoubleCodec;
import org.mariadb.jdbc.plugin.codec.FloatCodec;
import org.mariadb.jdbc.plugin.codec.GeometryCollectionCodec;
import org.mariadb.jdbc.plugin.codec.IntCodec;
import org.mariadb.jdbc.plugin.codec.LineStringCodec;
import org.mariadb.jdbc.plugin.codec.LongCodec;
import org.mariadb.jdbc.plugin.codec.MultiLinestringCodec;
import org.mariadb.jdbc.plugin.codec.MultiPointCodec;
import org.mariadb.jdbc.plugin.codec.MultiPolygonCodec;
import org.mariadb.jdbc.plugin.codec.PointCodec;
import org.mariadb.jdbc.plugin.codec.PolygonCodec;
import org.mariadb.jdbc.plugin.codec.ShortCodec;
import org.mariadb.jdbc.plugin.codec.StringCodec;
import org.mariadb.jdbc.plugin.codec.TimeCodec;
import org.mariadb.jdbc.plugin.codec.TimestampCodec;
import org.mariadb.jdbc.util.CharsetEncodingLength;

public class ColumnDefinitionPacket
implements Column,
ServerMessage {
    private final ReadableByteBuf buf;
    private final int charset;
    private final long length;
    private final DataType dataType;
    private final byte decimals;
    private final int flags;
    private final int[] stringPos;
    private final String extTypeName;
    private final String extTypeFormat;
    private boolean useAliasAsName;

    private ColumnDefinitionPacket(ReadableByteBuf buf, long length, DataType dataType, int[] stringPos) {
        this.buf = buf;
        this.charset = 33;
        this.length = length;
        this.dataType = dataType;
        this.decimals = 0;
        this.flags = 544;
        this.stringPos = stringPos;
        this.extTypeName = null;
        this.extTypeFormat = null;
    }

    public ColumnDefinitionPacket(ReadableByteBuf buf, boolean extendedInfo) {
        this.stringPos = new int[5];
        this.stringPos[0] = buf.skipIdentifier();
        this.stringPos[1] = buf.skipIdentifier();
        this.stringPos[2] = buf.skipIdentifier();
        this.stringPos[3] = buf.skipIdentifier();
        this.stringPos[4] = buf.skipIdentifier();
        buf.skipIdentifier();
        if (extendedInfo) {
            String tmpTypeName = null;
            String tmpTypeFormat = null;
            if (buf.readByte() != 0) {
                buf.pos(buf.pos() - 1);
                ReadableByteBuf subPacket = buf.readLengthBuffer();
                block4: while (subPacket.readableBytes() > 0) {
                    switch (subPacket.readByte()) {
                        case 0: {
                            tmpTypeName = subPacket.readAscii(subPacket.readLength());
                            continue block4;
                        }
                        case 1: {
                            tmpTypeFormat = subPacket.readAscii(subPacket.readLength());
                            continue block4;
                        }
                    }
                    subPacket.skip(subPacket.readLength());
                }
            }
            this.extTypeName = tmpTypeName;
            this.extTypeFormat = tmpTypeFormat;
        } else {
            this.extTypeName = null;
            this.extTypeFormat = null;
        }
        this.buf = buf;
        buf.skip();
        this.charset = buf.readShort();
        this.length = buf.readInt();
        this.dataType = DataType.of(buf.readUnsignedByte());
        this.flags = buf.readUnsignedShort();
        this.decimals = buf.readByte();
    }

    public static ColumnDefinitionPacket create(String name, DataType type) {
        int len;
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        byte[] arr = new byte[9 + 2 * nameBytes.length];
        arr[0] = 3;
        arr[1] = 68;
        arr[2] = 69;
        arr[3] = 70;
        int[] stringPos = new int[5];
        stringPos[0] = 4;
        stringPos[1] = 5;
        stringPos[2] = 6;
        int pos = 7;
        for (int i = 0; i < 2; ++i) {
            stringPos[i + 3] = pos;
            arr[pos++] = (byte)nameBytes.length;
            System.arraycopy(nameBytes, 0, arr, pos, nameBytes.length);
            pos += nameBytes.length;
        }
        switch (type) {
            case VARCHAR: 
            case VARSTRING: {
                len = 192;
                break;
            }
            case SMALLINT: {
                len = 5;
                break;
            }
            case NULL: {
                len = 0;
                break;
            }
            default: {
                len = 1;
            }
        }
        return new ColumnDefinitionPacket(new StandardReadableByteBuf(arr, arr.length), len, type, stringPos);
    }

    @Override
    public String getSchema() {
        this.buf.pos(this.stringPos[0]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public String getTableAlias() {
        this.buf.pos(this.stringPos[1]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public String getTable() {
        this.buf.pos(this.stringPos[this.useAliasAsName ? 1 : 2]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public String getColumnAlias() {
        this.buf.pos(this.stringPos[3]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public String getColumnName() {
        this.buf.pos(this.stringPos[4]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public DataType getType() {
        return this.dataType;
    }

    @Override
    public byte getDecimals() {
        return this.decimals;
    }

    @Override
    public boolean isSigned() {
        return (this.flags & 0x20) == 0;
    }

    @Override
    public int getDisplaySize() {
        Integer maxWidth;
        if (!(this.isBinary() || this.dataType != DataType.VARCHAR && this.dataType != DataType.JSON && this.dataType != DataType.ENUM && this.dataType != DataType.SET && this.dataType != DataType.VARSTRING && this.dataType != DataType.STRING && this.dataType != DataType.BLOB && this.dataType != DataType.TINYBLOB && this.dataType != DataType.MEDIUMBLOB && this.dataType != DataType.LONGBLOB || (maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset)) == null)) {
            return (int)(this.length / (long)maxWidth.intValue());
        }
        return (int)this.length;
    }

    @Override
    public boolean isPrimaryKey() {
        return (this.flags & 2) > 0;
    }

    @Override
    public boolean isAutoIncrement() {
        return (this.flags & 0x200) > 0;
    }

    @Override
    public boolean hasDefault() {
        return (this.flags & 0x1000) == 0;
    }

    @Override
    public boolean isBinary() {
        return this.charset == 63;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getExtTypeName() {
        return this.extTypeName;
    }

    @Override
    public int getPrecision() {
        switch (this.dataType) {
            case OLDDECIMAL: 
            case DECIMAL: {
                if (this.isSigned()) {
                    return (int)(this.length - (long)(this.decimals > 0 ? 2 : 1));
                }
                return (int)(this.length - (long)(this.decimals > 0 ? 1 : 0));
            }
            case VARCHAR: 
            case VARSTRING: 
            case JSON: 
            case ENUM: 
            case SET: 
            case STRING: {
                Integer maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset);
                if (maxWidth == null) {
                    return (int)this.length;
                }
                return (int)(this.length / (long)maxWidth.intValue());
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                Integer maxWidth2;
                if (!this.isBinary() && (maxWidth2 = CharsetEncodingLength.maxCharlen.get(this.charset)) != null) {
                    return (int)(this.length / (long)maxWidth2.intValue());
                }
                return (int)this.length;
            }
        }
        return (int)this.length;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        switch (this.dataType) {
            case TINYINT: {
                if (this.length == 1L) {
                    return conf.transformedBitIsBoolean() ? "BOOLEAN" : "BIT";
                }
                if (!this.isSigned()) {
                    return this.dataType.name() + " UNSIGNED";
                }
                return this.dataType.name();
            }
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: {
                if (!this.isSigned()) {
                    return this.dataType.name() + " UNSIGNED";
                }
                return this.dataType.name();
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (this.extTypeFormat != null) {
                    return this.extTypeFormat.toUpperCase(Locale.ROOT);
                }
                if (this.isBinary()) {
                    if (this.length < 0L) {
                        return "LONGBLOB";
                    }
                    if (this.length <= 255L) {
                        return "TINYBLOB";
                    }
                    if (this.length <= 65535L) {
                        return "BLOB";
                    }
                    if (this.length <= 0xFFFFFFL) {
                        return "MEDIUMBLOB";
                    }
                    return "LONGBLOB";
                }
                if (this.length < 0L) {
                    return "LONGTEXT";
                }
                if (this.getDisplaySize() <= 65532) {
                    return "VARCHAR";
                }
                if (this.getDisplaySize() <= 65535) {
                    return "TEXT";
                }
                if (this.getDisplaySize() <= 0xFFFFFF) {
                    return "MEDIUMTEXT";
                }
                return "LONGTEXT";
            }
            case VARCHAR: 
            case VARSTRING: {
                if (this.isBinary()) {
                    return "VARBINARY";
                }
                if (this.length < 0L) {
                    return "LONGTEXT";
                }
                if (this.getDisplaySize() <= 65532) {
                    return "VARCHAR";
                }
                if (this.getDisplaySize() <= 65535) {
                    return "TEXT";
                }
                if (this.getDisplaySize() <= 0xFFFFFF) {
                    return "MEDIUMTEXT";
                }
                return "LONGTEXT";
            }
            case STRING: {
                if (this.isBinary()) {
                    return "BINARY";
                }
                return "CHAR";
            }
            case GEOMETRY: {
                if (this.extTypeName != null) {
                    return this.extTypeName.toUpperCase(Locale.ROOT);
                }
                return this.dataType.name();
            }
        }
        return this.dataType.name();
    }

    @Override
    public int getColumnType(Configuration conf) {
        switch (this.dataType) {
            case TINYINT: {
                if (this.length == 1L) {
                    return conf.transformedBitIsBoolean() ? 16 : -7;
                }
                return this.isSigned() ? -6 : 5;
            }
            case BIT: {
                if (this.length == 1L) {
                    return 16;
                }
                return -3;
            }
            case SMALLINT: {
                return this.isSigned() ? 5 : 4;
            }
            case INTEGER: {
                return this.isSigned() ? 4 : -5;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 8;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return 93;
            }
            case BIGINT: {
                return -5;
            }
            case MEDIUMINT: {
                return 4;
            }
            case DATE: 
            case NEWDATE: {
                return 91;
            }
            case TIME: {
                return 92;
            }
            case YEAR: {
                if (conf.yearIsDateType()) {
                    return 91;
                }
                return 5;
            }
            case JSON: {
                return -1;
            }
            case VARCHAR: 
            case VARSTRING: 
            case ENUM: 
            case SET: 
            case BLOB: 
            case TINYBLOB: {
                if (this.length <= 0L || this.getDisplaySize() > 0xFFFFFF) {
                    return this.isBinary() ? -4 : -1;
                }
                return this.isBinary() ? -3 : 12;
            }
            case GEOMETRY: {
                return -3;
            }
            case STRING: {
                return this.isBinary() ? -3 : 1;
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return 3;
            }
            case MEDIUMBLOB: 
            case LONGBLOB: {
                return this.isBinary() ? -4 : -1;
            }
        }
        return 0;
    }

    @Override
    public Codec<?> getDefaultCodec(Configuration conf) {
        switch (this.dataType) {
            case VARCHAR: 
            case VARSTRING: 
            case NULL: 
            case JSON: 
            case ENUM: 
            case SET: 
            case STRING: {
                return StringCodec.INSTANCE;
            }
            case TINYINT: {
                if (conf.tinyInt1isBit() && this.length == 1L) {
                    return BooleanCodec.INSTANCE;
                }
                return IntCodec.INSTANCE;
            }
            case SMALLINT: {
                return this.isSigned() ? ShortCodec.INSTANCE : IntCodec.INSTANCE;
            }
            case INTEGER: {
                return this.isSigned() ? IntCodec.INSTANCE : LongCodec.INSTANCE;
            }
            case FLOAT: {
                return FloatCodec.INSTANCE;
            }
            case DOUBLE: {
                return DoubleCodec.INSTANCE;
            }
            case TIMESTAMP: 
            case DATETIME: {
                return TimestampCodec.INSTANCE;
            }
            case BIGINT: {
                return this.isSigned() ? LongCodec.INSTANCE : BigIntegerCodec.INSTANCE;
            }
            case MEDIUMINT: {
                return IntCodec.INSTANCE;
            }
            case DATE: 
            case NEWDATE: {
                return DateCodec.INSTANCE;
            }
            case OLDDECIMAL: 
            case DECIMAL: {
                return BigDecimalCodec.INSTANCE;
            }
            case GEOMETRY: {
                if (conf.geometryDefaultType() != null && "default".equals(conf.geometryDefaultType())) {
                    if (this.extTypeName != null) {
                        switch (this.extTypeName) {
                            case "point": {
                                return PointCodec.INSTANCE;
                            }
                            case "linestring": {
                                return LineStringCodec.INSTANCE;
                            }
                            case "polygon": {
                                return PolygonCodec.INSTANCE;
                            }
                            case "multipoint": {
                                return MultiPointCodec.INSTANCE;
                            }
                            case "multilinestring": {
                                return MultiLinestringCodec.INSTANCE;
                            }
                            case "multipolygon": {
                                return MultiPolygonCodec.INSTANCE;
                            }
                            case "geometrycollection": {
                                return GeometryCollectionCodec.INSTANCE;
                            }
                        }
                    }
                    return GeometryCollectionCodec.INSTANCE;
                }
                return ByteArrayCodec.INSTANCE;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                return this.isBinary() ? BlobCodec.INSTANCE : StringCodec.INSTANCE;
            }
            case TIME: {
                return TimeCodec.INSTANCE;
            }
            case YEAR: {
                if (conf.yearIsDateType()) {
                    return DateCodec.INSTANCE;
                }
                return ShortCodec.INSTANCE;
            }
            case BIT: {
                if (this.length == 1L) {
                    return BooleanCodec.INSTANCE;
                }
                return ByteArrayCodec.INSTANCE;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected datatype %s", new Object[]{this.dataType}));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinitionPacket that = (ColumnDefinitionPacket)o;
        return this.charset == that.charset && this.length == that.length && this.dataType == that.dataType && this.decimals == that.decimals && this.flags == that.flags;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.charset, this.length, this.dataType, this.decimals, this.flags});
    }

    @Override
    public void useAliasAsName() {
        this.useAliasAsName = true;
    }
}

