/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.helper;

import com.sun.star.comp.helper.ComponentContextEntry;
import com.sun.star.comp.helper.Disposer;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.DeploymentException;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentContext
implements XComponentContext,
XComponent {
    private static final boolean DEBUG = false;
    private static final String SMGR_NAME = "/singletons/com.sun.star.lang.theServiceManager";
    private static final String TDMGR_NAME = "/singletons/com.sun.star.reflection.theTypeDescriptionManager";
    private Map<String, Object> m_table;
    private XComponentContext m_xDelegate;
    private XMultiComponentFactory m_xSMgr;
    private boolean m_bDisposeSMgr;
    private ArrayList<XEventListener> m_eventListener = new ArrayList();

    public ComponentContext(Hashtable<String, Object> table, XComponentContext xDelegate) {
        this((Map<String, Object>)table, xDelegate);
    }

    public ComponentContext(Map<String, Object> table, XComponentContext xDelegate) {
        this.m_table = table;
        this.m_xDelegate = xDelegate;
        this.m_xSMgr = null;
        this.m_bDisposeSMgr = false;
        Object o = table.get(SMGR_NAME);
        if (o != null) {
            if (o instanceof ComponentContextEntry) {
                o = ((ComponentContextEntry)o).m_value;
            }
            this.m_xSMgr = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)o);
        }
        if (this.m_xSMgr != null) {
            this.m_bDisposeSMgr = true;
        } else if (this.m_xDelegate != null) {
            this.m_xSMgr = this.m_xDelegate.getServiceManager();
        }
        XComponent xComp = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.m_xDelegate);
        if (xComp != null) {
            xComp.addEventListener((XEventListener)new Disposer(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueByName(String rName) {
        Object o = this.m_table.get(rName);
        if (o == null) {
            if (this.m_xDelegate != null) {
                return this.m_xDelegate.getValueByName(rName);
            }
            return Any.VOID;
        }
        if (!(o instanceof ComponentContextEntry)) {
            return o;
        }
        ComponentContextEntry entry = (ComponentContextEntry)o;
        if (entry.m_lateInit == null) {
            return entry.m_value;
        }
        Object xInstance = null;
        try {
            String serviceName = (String)entry.m_lateInit;
            if (serviceName != null) {
                if (this.m_xSMgr != null) {
                    xInstance = this.m_xSMgr.createInstanceWithContext(serviceName, (XComponentContext)this);
                }
            } else {
                XSingleComponentFactory xCompFac = (XSingleComponentFactory)UnoRuntime.queryInterface(XSingleComponentFactory.class, (Object)entry.m_lateInit);
                if (xCompFac != null) {
                    xInstance = xCompFac.createInstanceWithContext((XComponentContext)this);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xInstance != null) {
            ComponentContextEntry componentContextEntry = entry;
            synchronized (componentContextEntry) {
                if (entry.m_lateInit != null) {
                    entry.m_value = xInstance;
                    entry.m_lateInit = null;
                } else {
                    XComponent xComp = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)xInstance);
                    if (xComp != null) {
                        xComp.dispose();
                    }
                }
            }
        }
        return entry.m_value;
    }

    public XMultiComponentFactory getServiceManager() {
        if (this.m_xSMgr == null) {
            throw new DeploymentException("null component context service manager");
        }
        return this.m_xSMgr;
    }

    public void dispose() {
        XComponent xComponent;
        EventObject evt = new EventObject((Object)this);
        for (XEventListener xEventListener : this.m_eventListener) {
            xEventListener.disposing(evt);
        }
        this.m_eventListener.clear();
        XComponent tdmgr = null;
        for (Map.Entry<String, Object> entry : this.m_table.entrySet()) {
            XComponent xComp2;
            String name = entry.getKey();
            if (name.equals(SMGR_NAME)) continue;
            Object o = entry.getValue();
            if (o instanceof ComponentContextEntry) {
                o = ((ComponentContextEntry)o).m_value;
            }
            if ((xComp2 = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)o)) == null) continue;
            if (name.equals(TDMGR_NAME)) {
                tdmgr = xComp2;
                continue;
            }
            xComp2.dispose();
        }
        this.m_table.clear();
        if (this.m_bDisposeSMgr && (xComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)this.m_xSMgr)) != null) {
            xComponent.dispose();
        }
        this.m_xSMgr = null;
        if (tdmgr != null) {
            tdmgr.dispose();
        }
    }

    public void addEventListener(XEventListener xListener) {
        if (xListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (this.m_eventListener.contains(xListener)) {
            throw new RuntimeException("Listener already registered.");
        }
        this.m_eventListener.add(xListener);
    }

    public void removeEventListener(XEventListener xListener) {
        if (xListener == null) {
            throw new RuntimeException("Listener must not be null");
        }
        if (!this.m_eventListener.contains(xListener)) {
            throw new RuntimeException("Listener is not registered.");
        }
        this.m_eventListener.remove(xListener);
    }
}

