/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pdf.service.action;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.openscdp.pdf.service.EmailClient;
import org.openscdp.pdf.service.PDFGenerator;
import org.openscdp.pdf.service.servicerequest.PDFServiceRequest;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestSingleAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFAction
extends ServiceRequestSingleAction {
    final Logger logger = LoggerFactory.getLogger(PDFAction.class);
    private PDFServiceRequest sr;
    private PDFGenerator gen;
    private String emailTemplatesDir;

    public PDFAction(PDFServiceRequest sr, PDFGenerator gen, String emailTemplatesDir, Long userId) {
        super((ServiceRequest)sr);
        this.sr = sr;
        this.gen = gen;
        this.emailTemplatesDir = emailTemplatesDir;
    }

    private void createPDF(String emailTemplatesDir) {
        String template = this.sr.getTemplate();
        Map<String, String> map = this.sr.getFields();
        try {
            File emailTemplate = new File(emailTemplatesDir + "/template/" + template + ".txt");
            String text = this.getTextFromEmailTemplate(emailTemplate, map);
            byte[] pdf = this.gen.getPDFFromTemplate(template, map);
            String subject = this.sr.getTitle() + " #" + this.sr.getId();
            EmailClient.sendMail(this.sr.getEmail(), subject, text, template + ".pdf", pdf);
        }
        catch (Exception e) {
            this.logger.error("createPDF() failed ", (Throwable)e);
            throw new ServiceRequestActionException("createPDF() failed (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
    }

    private String getTextFromEmailTemplate(File file, Map<String, String> map) {
        String template = this.readFile(file);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = "{" + entry.getKey() + "}";
            String val = entry.getValue();
            if (!template.contains(key)) continue;
            template = template.replace(key, val);
        }
        return template;
    }

    private String readFile(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            byte[] encodedText = null;
            try (DataInputStream dis = new DataInputStream(fis);){
                int n = dis.available();
                encodedText = new byte[n];
                if (n > 0) {
                    dis.read(encodedText);
                }
            }
            catch (IOException e) {
                this.logger.error("readFile() failed ", (Throwable)e);
                throw new ServiceRequestActionException("readFile() failed (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
            }
            String text = new String(encodedText);
            return text;
        }
        catch (FileNotFoundException e) {
            this.logger.error("readFile() failed ", (Throwable)e);
            throw new ServiceRequestActionException("readFile() failed (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeImpl() {
        this.createPDF(this.emailTemplatesDir);
    }
}

