/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.util;

import de.cardcontact.tlv.HexString;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUFormatter;
import opencard.core.util.APDUTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JAPDUTracer
implements APDUTracer {
    final Logger logger = LoggerFactory.getLogger(SLF4JAPDUTracer.class);

    @Override
    public void traceCommandAPDU(SlotChannel sc, CommandAPDU capdu) {
        if (this.logger.isDebugEnabled()) {
            int slotId = sc.getCardTerminal().getName().hashCode() + sc.getSlotNumber() & 0xFF;
            String s = HexString.hexifyByte(slotId);
            s = s.concat(" ");
            s = s.concat(APDUFormatter.commandAPDUToString(capdu));
            this.logger.debug(s);
        }
    }

    @Override
    public void traceResponseAPDU(SlotChannel sc, ResponseAPDU rapdu) {
        if (this.logger.isDebugEnabled()) {
            String s = APDUFormatter.responseAPDUToString(rapdu);
            this.logger.debug(s);
        }
    }

    @Override
    public void traceAnswerToReset(SlotChannel sc, CardID cardID) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" ATR: " + HexString.hexifyByteArray(cardID.getATR()));
        }
    }
}

