/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc.importer;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.cvc.importer.SCHSMTokenCertificateImporter;
import org.openscdp.pkihsmsrv.HSMServiceEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSMServiceImporter
implements HSMServiceEventListener {
    private final Logger logger = LoggerFactory.getLogger(HSMServiceImporter.class);
    private SCHSMTokenCertificateImporter importer;

    public HSMServiceImporter(String seenAt) {
        this.importer = new SCHSMTokenCertificateImporter(seenAt);
    }

    public void attached(SmartCardHSMProvider provider) {
        try {
            this.importer.importDeviceChain(provider.getSmartCardHSMCardService());
            try (Handle handle = PKIDMContext.getJDBI().open();){
                TokenDAO tokenDAO = (TokenDAO)handle.attach(TokenDAO.class);
                tokenDAO.updateOnlineStatus(provider.getSmartCardHSMCardService().getId(), 1);
            }
        }
        catch (Exception e) {
            this.logger.error("Import device certificate chain failed", (Throwable)e);
        }
    }

    public void detached(SmartCardHSMProvider provider) {
        try (Handle handle = PKIDMContext.getJDBI().open();){
            TokenDAO tokenDAO = (TokenDAO)handle.attach(TokenDAO.class);
            tokenDAO.updateOnlineStatus(provider.getSmartCardHSMCardService().getId(), 0);
        }
        catch (Exception e) {
            this.logger.error("Recording disconnect failed", (Throwable)e);
        }
    }
}

