/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.dao;

import java.util.List;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openscdp.pkidb.dto.SignerDTO;

@RegisterBeanMapper(value=SignerDTO.class)
public interface SignerDAO
extends SqlObject {
    @SqlUpdate(value="INSERT INTO Signer (holderId, name, keyId, keyDomain, keyblob, content) VALUES(:holderId, :name, :keyId, :keyDomain, :keyblob, :content)")
    @GetGeneratedKeys(value={"id"})
    public Long insert(@BindBean SignerDTO var1);

    default public SignerDTO create(SignerDTO signer) {
        Long id = this.insert(signer);
        signer.setId(id);
        return signer;
    }

    @SqlUpdate(value="UPDATE Signer SET holderId = :holderId, name = :name, keyId = :keyId, keyDomain = :keyDomain, keyblob = :keyblob, content = :content WHERE id = :id")
    public void update(@BindBean SignerDTO var1);

    @SqlQuery(value="SELECT * FROM Signer WHERE id = ?")
    public SignerDTO getSigner(Long var1);

    @SqlQuery(value="SELECT * FROM Signer WHERE holderId = ? AND name = ?")
    public SignerDTO getSignerByHolderAndName(Long var1, String var2);

    @SqlQuery(value="SELECT * FROM Signer WHERE keyId = ?")
    public SignerDTO getSignerByKeyId(byte[] var1);

    @SqlQuery(value="SELECT * FROM Signer WHERE holderId = ? AND keyId = ?")
    public SignerDTO getSignerByHolderAndKeyId(Long var1, byte[] var2);

    @SqlQuery(value="SELECT * FROM Signer WHERE holderId = ?")
    public List<SignerDTO> getSignerByHolderId(Long var1);

    @SqlQuery(value="SELECT count(1) FROM Signer WHERE holderId = ?")
    public Long countSigner(Long var1);
}

