/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.service.isocard;

import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.isocard.IsoFileControlInformation;
import java.util.Enumeration;
import opencard.core.service.CardChannel;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.core.util.HexString;
import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFileInfo;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardFileShortFileID;
import opencard.opt.service.CardServiceObjectNotAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsoCardSelector {
    private static final CardFileFileID root_file = new CardFileFileID(16128);
    private static final Logger logger = LoggerFactory.getLogger(IsoCardSelector.class);
    public static final int ALREADY_SELECTED = -1;
    public static final int NEWLY_SELECTED = 0;
    private CardFilePath rootPath;
    private CardFilePath currentPath;
    private CardFileInfo currentFCI;
    private boolean isElementaryFile;
    private byte selectFCI;
    private boolean leInSelectEnabled;
    private boolean supportsP1InSelect;

    public IsoCardSelector(CardFilePath root) {
        this.rootPath = root;
        this.currentPath = root;
        this.currentFCI = null;
        this.selectFCI = (byte)4;
        this.isElementaryFile = false;
        this.leInSelectEnabled = true;
        this.supportsP1InSelect = true;
    }

    public CardFilePath getPath() {
        return this.currentPath;
    }

    public CardFileInfo getFCI() {
        return this.currentFCI;
    }

    public boolean elementaryFileSelected() {
        return this.isElementaryFile;
    }

    public void setSelectCommandResponseQualifier(byte p2) {
        this.selectFCI = p2;
    }

    public byte getSelectCommandResponseQualifier() {
        return this.selectFCI;
    }

    public void setLeInSelectFlag(boolean flag) {
        this.leInSelectEnabled = flag;
    }

    public boolean isLeInSelectEnabled() {
        return this.leInSelectEnabled;
    }

    public void setImplicitlySelectedBySFI(CardFilePath file) {
        this.currentPath = file;
        this.currentFCI = null;
        this.isElementaryFile = true;
    }

    protected ResponseAPDU doSelect(CardChannel channel, CardFilePathComponent comp, boolean isDF, byte p1, SecureChannelCredential secureChannelCredential) throws InvalidCardChannelException, CardTerminalException {
        ResponseAPDU res;
        CommandAPDU com = new CommandAPDU(30);
        com.append((byte)0);
        com.append((byte)-92);
        if (p1 != -1) {
            com.append(p1);
        } else if (comp == null) {
            com.append((byte)3);
        } else if (comp instanceof CardFileAppID) {
            com.append((byte)4);
        } else if (comp.equals(root_file)) {
            com.append((byte)0);
        } else if (this.supportsP1InSelect) {
            com.append(isDF ? (byte)1 : 2);
        } else {
            com.append((byte)0);
        }
        com.append(this.selectFCI);
        if (comp != null) {
            if (comp instanceof CardFileFileID) {
                com.append((byte)2);
                com.append(((CardFileFileID)comp).toByteArray());
            } else if (comp instanceof CardFileAppID) {
                byte[] aid = ((CardFileAppID)comp).toByteArray();
                com.append((byte)aid.length);
                com.append(aid);
            }
        }
        if (this.leInSelectEnabled) {
            com.append((byte)0);
        }
        if (secureChannelCredential != null) {
            SlotChannel slc = channel.getSlotChannel();
            APDUTracer tracer = slc.getAPDUTracer();
            if (tracer != null && com.getLength() > 5) {
                tracer.traceCommandAPDU(slc, com);
            }
            int uq = secureChannelCredential.getUsageQualifier();
            SecureChannel sc = secureChannelCredential.getSecureChannel();
            com = sc.wrap(com, uq);
            res = channel.sendCommandAPDU(com);
            res = sc.unwrap(res, uq);
            if (tracer != null && res.getLength() > 2) {
                tracer.traceResponseAPDU(slc, res);
            }
        } else {
            res = channel.sendCommandAPDU(com);
        }
        if (res.sw1() == 97) {
            com.setLength(0);
            com.append((byte)0);
            com.append((byte)-64);
            com.append((byte)0);
            com.append((byte)0);
            com.append(res.sw2());
            res = channel.sendCommandAPDU(com);
        }
        return res;
    }

    public synchronized int selectFile(CardChannel channel, SecureChannelCredential secureChannelCredential, CardFilePath path, boolean explicit) throws InvalidCardChannelException, CardTerminalException, CardServiceObjectNotAvailableException, CardServiceUnexpectedStatusWordException {
        boolean selectFromRoot = false;
        ResponseAPDU res = new ResponseAPDU(new byte[]{-112, 0});
        if (path.equals(this.currentPath) && !explicit) {
            logger.debug("[selectFile] File already selected");
            return -1;
        }
        CardFilePath currentDir = new CardFilePath(this.currentPath);
        if (this.isElementaryFile) {
            logger.debug("[selectFile] Stripping last element of current path");
            if (!currentDir.chompTail()) {
                selectFromRoot = true;
            } else if (currentDir.equals(path) && !explicit) {
                logger.debug("[selectFile] Directory already selected");
                this.currentFCI = null;
                return -1;
            }
        }
        CardFilePath toselect = new CardFilePath(path);
        if (path.startsWith(currentDir)) {
            toselect.chompPrefix(currentDir);
        } else {
            int common = toselect.commonPrefixLength(currentDir);
            if (common > 0 && currentDir.numberOfComponents() - common == 1) {
                res = this.doSelect(channel, null, false, (byte)-1, secureChannelCredential);
                if (res.sw() == 36864 || res.sw() == 25219) {
                    this.isElementaryFile = false;
                    currentDir.chompTail();
                    if (currentDir.equals(toselect)) {
                        logger.debug("[selectFile] FCI = " + HexString.hexify(res.data()));
                        this.currentFCI = res.getLength() > 2 ? new IsoFileControlInformation(res.data()) : new IsoFileControlInformation();
                        this.currentPath = currentDir;
                        return 0;
                    }
                    toselect.chompPrefix(currentDir);
                } else {
                    selectFromRoot = true;
                }
            } else {
                selectFromRoot = true;
            }
        }
        if (selectFromRoot) {
            currentDir = null;
        }
        logger.debug("[selectFile] Going to select " + toselect.toString());
        Enumeration components = toselect.components();
        int count = toselect.numberOfComponents();
        boolean assumeDF = true;
        while (components.hasMoreElements()) {
            CardFilePathComponent comp = (CardFilePathComponent)components.nextElement();
            if (comp instanceof CardFileShortFileID) {
                if (currentDir != null) {
                    this.currentPath = currentDir;
                }
                this.isElementaryFile = false;
                this.currentFCI = null;
                logger.debug("[selectFile] Last path component is a short file identifier" + String.valueOf(comp));
                return ((CardFileShortFileID)comp).toByte();
            }
            if (comp instanceof CardFileFileID && count == 1) {
                assumeDF = false;
            }
            if ((res = this.doSelect(channel, comp, assumeDF, (byte)-1, secureChannelCredential)).sw1() == 103 && selectFromRoot) {
                logger.debug("[selectFile] Invalid length when selecting MF - Trying without data");
                res = this.doSelect(channel, null, assumeDF, (byte)0, secureChannelCredential);
            }
            if (res.sw() == 27270 || res.sw() == 27392 || res.sw() == 27265 || res.sw() == 27136 || res.sw1() == 103) {
                logger.debug("[selectFile] Invalid P1/P2 - Trying FCI instead of FCP");
                this.selectFCI = 0;
                res = this.doSelect(channel, comp, assumeDF, (byte)-1, secureChannelCredential);
                if (res.sw() == 27270 || res.sw() == 27392 || res.sw() == 27265 || res.sw() == 27136 || res.sw1() == 103) {
                    logger.debug("[selectFile] Invalid P1/P2 - Trying with P1 = 0");
                    this.supportsP1InSelect = false;
                    res = this.doSelect(channel, comp, assumeDF, (byte)-1, secureChannelCredential);
                }
                if (res.sw() == 27270 || res.sw() == 27392 || res.sw() == 27265 || res.sw() == 27136 || res.sw1() == 103) {
                    logger.debug("[selectFile] Invalid P1/P2 - Trying with P1 = 0");
                    this.supportsP1InSelect = false;
                    this.selectFCI = (byte)4;
                    res = this.doSelect(channel, comp, assumeDF, (byte)-1, secureChannelCredential);
                }
                if (res.sw() == 26368) {
                    logger.debug("[selectFile] Wrong length - Trying without Le");
                    this.leInSelectEnabled = false;
                    res = this.doSelect(channel, comp, assumeDF, (byte)-1, secureChannelCredential);
                }
                if (res.sw() == 26368) {
                    logger.debug("[selectFile] Wrong length - Trying with P1='0C' and without Le");
                    this.leInSelectEnabled = false;
                    this.supportsP1InSelect = true;
                    this.selectFCI = (byte)12;
                    res = this.doSelect(channel, comp, assumeDF, (byte)-1, secureChannelCredential);
                }
            }
            if (res.sw() == 27266 && !assumeDF) {
                logger.debug("[selectFile] EF not found - Trying DF");
                assumeDF = true;
                res = this.doSelect(channel, comp, assumeDF, (byte)-1, secureChannelCredential);
            }
            if (res.sw() == 36864 || res.sw() == 25219 || res.sw1() == 97) {
                if (currentDir == null) {
                    currentDir = new CardFilePath(comp.toString());
                    assumeDF = true;
                } else {
                    currentDir.append(comp);
                }
                logger.debug("[selectFile] FCI = " + HexString.hexify(res.data()));
                this.currentFCI = res.getLength() > 2 ? new IsoFileControlInformation(res.data()) : new IsoFileControlInformation();
            } else {
                logger.error("[selectFile] SW1SW2 = " + HexString.hexifyShort(res.sw()));
                assumeDF = true;
                break;
            }
            --count;
        }
        if (currentDir != null) {
            this.currentPath = currentDir;
            boolean bl = this.isElementaryFile = !assumeDF;
        }
        if (res.sw() == 27266) {
            throw new CardServiceObjectNotAvailableException("File not found");
        }
        if (res.sw() != 36864 && res.sw() != 25219 && res.sw1() != 97) {
            throw new CardServiceUnexpectedStatusWordException("SELECT", res.sw());
        }
        return 0;
    }

    public int selectFile(CardChannel channel, SecureChannelCredential secureChannelCredential, CardFilePath path) throws InvalidCardChannelException, CardTerminalException, CardServiceObjectNotAvailableException, CardServiceUnexpectedStatusWordException {
        return this.selectFile(channel, secureChannelCredential, path, false);
    }
}

