/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.ProviderException;
import java.security.SecureRandomSpi;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRandom
extends SecureRandomSpi {
    private static final Logger log = LoggerFactory.getLogger(SecureRandom.class);
    private static final long serialVersionUID = -1130070973762733185L;
    private SmartCardHSMProvider provider;
    private SmartCardHSMCardService schsm;

    public SecureRandom(SmartCardHSMProvider provider, String algorithm) {
        this.provider = provider;
        this.schsm = provider.getSmartCardHSMCardService();
    }

    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
        byte[] seed = null;
        try {
            seed = this.schsm.generateRandom(numBytes);
        }
        catch (CardTerminalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardServiceException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        return seed;
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
        try {
            byte[] rnd = this.schsm.generateRandom(bytes.length);
            System.arraycopy(rnd, 0, bytes, 0, rnd.length);
        }
        catch (CardTerminalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardServiceException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    protected void engineSetSeed(byte[] seed) {
    }
}

