/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pdf.service;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.util.Properties;

public class EmailClient {
    private static String smtpserver;
    private static String emailfrom;
    private static String emailbcc;

    public static void setSMTPServer(String server) {
        smtpserver = server;
    }

    public static void setSender(String emailfrom) {
        EmailClient.emailfrom = emailfrom;
    }

    public static void setBCC(String emailbcc) {
        EmailClient.emailbcc = emailbcc;
    }

    public static void sendMail(String recipient, String subject, String text, String filename, byte[] pdf) {
        Properties prop = System.getProperties();
        prop.setProperty("mail.smtp.host", smtpserver);
        Session session = Session.getDefaultInstance((Properties)prop);
        MimeMessage msg = new MimeMessage(session);
        try {
            msg.setFrom((Address)new InternetAddress(emailfrom));
            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient));
            if (emailbcc != null) {
                msg.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(emailbcc));
            }
            msg.setSubject(subject);
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(text);
            MimeBodyPart pdfPart = new MimeBodyPart();
            ByteArrayDataSource ds = new ByteArrayDataSource(pdf, "application/pdf");
            pdfPart.setDataHandler(new DataHandler((DataSource)ds));
            pdfPart.setFileName(filename);
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)textPart);
            mp.addBodyPart((BodyPart)pdfPart);
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Sending mail failed", e);
        }
    }
}

