/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DirectoryAttribute
extends Sequence {
    private ConstructedTLV contents = null;

    public DirectoryAttribute(ObjectIdentifier newoid) {
        this.add(newoid);
        this.contents = new ConstructedTLV(new Tag(17, 0, true));
        this.add(this.contents);
    }

    public DirectoryAttribute(TLV tlv) throws TLVEncodingException {
        super(tlv);
        if (this.tag.getNumber() != 16 || !this.tag.isConstructed()) {
            throw new TLVEncodingException("Directory attribute does not start with SEQUENCE");
        }
        TLV oid = this.findTag(new Tag(6), null);
        if (oid == null) {
            throw new TLVEncodingException("Object identifier not found");
        }
        TLV res = this.findTag(new Tag(17, 0, true), null);
        if (res == null || !(res instanceof ConstructedTLV)) {
            throw new TLVEncodingException("Contents set not found");
        }
        this.contents = (ConstructedTLV)res;
    }

    public void addElement(TLV element) {
        this.contents.add(element);
    }

    public TLV getElement(int tag) {
        return this.contents.findTag(new Tag((byte)tag, 0, false), null);
    }

    public String getString(int tag, String encoding) throws UnsupportedEncodingException {
        String rc = null;
        TLV tlv = this.getElement(tag);
        if (tlv != null && tlv instanceof PrimitiveTLV) {
            rc = new String(((PrimitiveTLV)tlv).getValue(), encoding);
        }
        return rc;
    }

    public void addNumericString(String numericString) throws UnsupportedEncodingException {
        this.addElement(new PrimitiveTLV(new Tag(18, 0, false), numericString.getBytes("8859_1")));
    }

    public String getNumericString() throws UnsupportedEncodingException {
        return this.getString(18, "8859_1");
    }

    public void addUTF8String(String utf8String) throws UnsupportedEncodingException {
        this.addElement(new PrimitiveTLV(new Tag(12, 0, false), utf8String.getBytes("UTF-8")));
    }

    public String getUTF8String() throws UnsupportedEncodingException {
        return this.getString(12, "UTF-8");
    }

    public void addPrintableString(String printableString) throws UnsupportedEncodingException {
        this.addElement(new PrimitiveTLV(new Tag(19, 0, false), printableString.getBytes("8859_1")));
    }

    public String getPrintableString() throws UnsupportedEncodingException {
        return this.getString(19, "8859_1");
    }

    public void addLatin1String(String latin1String) throws UnsupportedEncodingException {
        this.addElement(new PrimitiveTLV(new Tag(4, 0, false), latin1String.getBytes("8859_1")));
    }

    public String getLatin1String() throws UnsupportedEncodingException {
        return this.getString(4, "8859_1");
    }

    public void addGeneralizedTime(Date date) throws UnsupportedEncodingException {
        SimpleDateFormat form = new SimpleDateFormat("yyyyMMdd'120000Z'");
        String output = form.format(date);
        this.addElement(new PrimitiveTLV(new Tag(24, 0, false), output.getBytes("8859_1")));
    }

    public Date getGeneralizedTime() throws UnsupportedEncodingException {
        ParsePosition pp;
        SimpleDateFormat form = new SimpleDateFormat("yyyyMMddHHmmss");
        String val = this.getString(24, "8859_1");
        Date date = null;
        if (val != null && (date = form.parse(val, pp = new ParsePosition(0))) == null) {
            throw new UnsupportedEncodingException("Date " + val + " parse error at position " + pp.getErrorIndex());
        }
        return date;
    }

    public ObjectIdentifier getOID() {
        TLV oid = this.findTag(new Tag(6, 0, false), null);
        if (oid != null && oid instanceof ObjectIdentifier) {
            return (ObjectIdentifier)oid;
        }
        return null;
    }

    public boolean isOID(ObjectIdentifier testoid) {
        return this.getOID().equals(testoid);
    }
}

