/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pdf.service.servicerequest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pdf.service.PDFGenerator;
import org.openscdp.pdf.service.action.PDFAction;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestContentView;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFServiceRequest
implements ServiceRequest {
    final Logger logger = LoggerFactory.getLogger(PDFServiceRequest.class);
    static final ObjectMapper om = new ObjectMapper();
    public static final String FIELD_PDF_TEMPLATE = "pdfTemplate";
    public static final String FIELD_PDF_FIELD_KEYS = "pdfFieldKeys";
    public static final String PREFIX_SR_CONTENT = "sr.content.";
    public static final String PREFIX_SR = "sr.";
    public static final String PREFIX_SUBJECT = "subject.";
    public static final String PREFIX_SUBJECT_CONTENT = "subject.content.";
    protected Map<String, Object> content;
    protected Map<String, Object> originatorContent;
    private ServiceRequestDTO dto;
    private SubjectDTO originator;
    private PDFGenerator gen;
    private String emailTemplatesDir;

    public PDFServiceRequest(ServiceRequestDTO dto, PDFGenerator gen, String emailTemplatesDir) {
        this.dto = dto;
        this.gen = gen;
        this.emailTemplatesDir = emailTemplatesDir;
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        return new PDFAction(this, this.gen, this.emailTemplatesDir, action.user);
    }

    public Map<String, Object> getContent() {
        if (this.content == null) {
            this.content = this.parseContent(this.dto.getContent());
        }
        return this.content;
    }

    public SubjectDTO getOriginator() {
        if (this.originator == null) {
            Jdbi jdbi = PKIDMContext.getJDBI();
            try (Handle handle = jdbi.open();){
                SubjectDAO dao = (SubjectDAO)handle.attach(SubjectDAO.class);
                this.originator = dao.getSubject(this.dto.getOriginatorId().longValue());
            }
        }
        return this.originator;
    }

    public Map<String, Object> getOriginatorContent() {
        if (this.originatorContent == null) {
            this.originatorContent = this.parseContent(this.getOriginator().getContent());
        }
        return this.originatorContent;
    }

    private Map<String, Object> parseContent(String content) {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        try {
            return (Map)om.readValue(content, (TypeReference)typeRef);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse content : " + content, (Throwable)e);
            throw new RuntimeException("Failed to parse content field", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, String> getFields() {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Object> c = this.getContent();
        Object o = c.get(FIELD_PDF_FIELD_KEYS);
        if (o == null) {
            throw new RuntimeException("Missing required content field pdfFieldKeys");
        }
        if (!(o instanceof List)) {
            throw new RuntimeException("Invalid type of content field pdfFieldKeys");
        }
        List keys = (List)o;
        for (String key : keys) {
            Object value;
            String k;
            if (key.startsWith(PREFIX_SR_CONTENT)) {
                k = key.substring(PREFIX_SR_CONTENT.length());
                value = c.get(k);
            } else if (key.startsWith(PREFIX_SR)) {
                k = key.substring(PREFIX_SR.length());
                if (!k.equals("id")) throw new RuntimeException("Unknown field " + k);
                value = this.dto.getId().toString();
            } else if (key.startsWith(PREFIX_SUBJECT_CONTENT)) {
                k = key.substring(PREFIX_SUBJECT_CONTENT.length());
                value = this.getOriginatorContent().get(k);
            } else {
                if (!key.startsWith(PREFIX_SUBJECT)) throw new RuntimeException("Unknown key " + key);
                k = key.substring(PREFIX_SUBJECT.length());
                if (k.equals("email")) {
                    value = this.getEmail();
                } else {
                    if (!k.equals("name")) throw new RuntimeException("Unknown field " + k);
                    value = this.getOriginator().getName();
                }
            }
            if (value == null) {
                throw new RuntimeException("Field " + k + " not found");
            }
            if (!(value instanceof String)) {
                throw new RuntimeException("Invalid type of field " + k);
            }
            map.put(key, (String)value);
        }
        return map;
    }

    public String getTemplate() {
        Object o = this.getContent().get(FIELD_PDF_TEMPLATE);
        if (o == null) {
            throw new RuntimeException("Missing required content field pdfTemplate");
        }
        if (!(o instanceof String)) {
            throw new RuntimeException("Invalid type of content field pdfTemplate");
        }
        return (String)o;
    }

    public Long getId() {
        return this.dto.getId();
    }

    public String getTitle() {
        return this.dto.getTitle();
    }

    public String getEmail() {
        return this.getOriginator().getEmail();
    }

    public void setStatusInfo(String info) {
        this.dto.setState(info);
    }

    public void setActionInfo(String info) {
    }

    public String getActionInfo() {
        return null;
    }

    public void commit(Long subjectId, ServiceRequestStateContent content) {
        String jsonstr;
        if (content != null) {
            om.enable(SerializationFeature.INDENT_OUTPUT);
            try {
                jsonstr = om.writeValueAsString((Object)content);
            }
            catch (JsonProcessingException e) {
                this.logger.error("Error setting content", (Throwable)e);
                throw new RuntimeException("Error setting content", e);
            }
        } else {
            jsonstr = "{}";
        }
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dao.addLifeCycleTransition(this.dto, subjectId, jsonstr);
        }
    }

    public int getLifeCycle() {
        return this.dto.getLifecycle();
    }

    public Long getOriginatorId() {
        return this.dto.getOriginatorId();
    }

    public Long getRecipientId() {
        return this.dto.getRecipientId();
    }

    public void setLifeCycle(int state) {
        this.dto.setLifecycle(Integer.valueOf(state));
    }

    public void setRoleId(Long roleId) {
        this.dto.setAssignedToRole(roleId);
    }

    public void updateContent(ServiceRequestContentView arg0) {
        this.logger.error("Not implemented");
        throw new RuntimeException("Not implemented");
    }

    public ServiceRequestDTO getDTO() {
        return null;
    }

    public JsonNode getContentTree() {
        return null;
    }

    public void setUserId(Long userId) {
    }

    public void commit(ServiceRequestStateContent content) {
    }

    public void updateDetails(String details) {
    }
}

