/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.opencard.eac.cvc;

import de.cardcontact.opencard.eac.cvc.PublicKeyTLV;
import de.cardcontact.tlv.IntegerTLV;
import de.cardcontact.tlv.Sequence;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.math.BigInteger;

public class ECSignature {
    public static byte[] wrapSignature(byte[] signature) {
        int length = signature.length / 2;
        byte[] ib = new byte[length];
        System.arraycopy(signature, 0, ib, 0, length);
        BigInteger r = new BigInteger(1, ib);
        System.arraycopy(signature, length, ib, 0, length);
        BigInteger s = new BigInteger(1, ib);
        Sequence sequence = new Sequence();
        sequence.add(new IntegerTLV(r));
        sequence.add(new IntegerTLV(s));
        return sequence.getBytes();
    }

    public static byte[] unwrapSignature(byte[] signature, int size) {
        TLV t;
        try {
            t = TLV.factory(signature);
        }
        catch (TLVEncodingException e) {
            throw new IllegalArgumentException("Signature is not a TLV object");
        }
        if (!(t instanceof Sequence)) {
            throw new IllegalArgumentException("Signature missing outer Sequence");
        }
        Sequence s = (Sequence)t;
        if (s.getChildCount() != 2) {
            throw new IllegalArgumentException("Signature must contain two elements");
        }
        if (!(s.getChildAt(0) instanceof IntegerTLV) || !(s.getChildAt(1) instanceof IntegerTLV)) {
            throw new IllegalArgumentException("Signature must contain two integer");
        }
        byte[] uwsig = new byte[size << 1];
        IntegerTLV i = (IntegerTLV)s.getChildAt(0);
        PublicKeyTLV.toUnsignedByteArray(i.getValue(), uwsig, 0, size);
        i = (IntegerTLV)s.getChildAt(1);
        PublicKeyTLV.toUnsignedByteArray(i.getValue(), uwsig, size, size);
        return uwsig;
    }

    public static byte[] rewrapSignature(byte[] signature) {
        TLV t;
        try {
            t = TLV.factory(signature);
        }
        catch (TLVEncodingException e) {
            throw new IllegalArgumentException("Signature is not a TLV object");
        }
        if (!(t instanceof Sequence)) {
            throw new IllegalArgumentException("Signature missing outer Sequence");
        }
        Sequence seq = (Sequence)t;
        if (seq.getChildCount() != 2) {
            throw new IllegalArgumentException("Signature must contain two elements");
        }
        if (!(seq.getChildAt(0) instanceof IntegerTLV) || !(seq.getChildAt(1) instanceof IntegerTLV)) {
            throw new IllegalArgumentException("Signature must contain two integer");
        }
        IntegerTLV r = (IntegerTLV)seq.getChildAt(0);
        IntegerTLV s = (IntegerTLV)seq.getChildAt(1);
        if (r.getValue()[0] == 0 && r.getValue()[1] >= 0 || s.getValue()[0] == 0 && s.getValue()[1] >= 0) {
            seq = new Sequence();
            seq.add(new IntegerTLV(r.getBigInteger()));
            seq.add(new IntegerTLV(s.getBigInteger()));
            return seq.getBytes();
        }
        return signature;
    }
}

