/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pdf.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.openscdp.pdf.service.PDFGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFServlet
extends HttpServlet {
    final Logger logger = LoggerFactory.getLogger(PDFServlet.class);
    public static final String TEXT_PLAIN = "text/plain";
    public static final String APPLICATION_PDF = "application/pdf";

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.logger.info("doPost");
        String json = this.getJSON(req);
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Map fields = (Map)map.get("fields");
        PDFGenerator gen = (PDFGenerator)req.getServletContext().getAttribute("PDFGEN");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] pdf = gen.getPDFFromTemplate("TextTemplateWithUserFields.odt", fields);
            baos.write(pdf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        resp.setContentType(APPLICATION_PDF);
        resp.setContentLength(baos.size());
        ServletOutputStream out = resp.getOutputStream();
        baos.writeTo((OutputStream)out);
        out.close();
    }

    private String getJSON(HttpServletRequest req) throws IOException {
        return req.getReader().lines().collect(Collectors.joining());
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.logger.info("doGet");
    }
}

