/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.ejbca.connector.pkidm.servicerequest;

import org.openscdp.ejbca.connector.pkidm.action.ImportProfilesAction;
import org.openscdp.ejbca.connector.pkidm.servicerequest.ConnectTrustCenterWithEJBCAServiceRequestContent;
import org.openscdp.ejbca.connector.pkidm.servicerequest.EJBCAServiceRequest;
import org.openscdp.ejbca.connector.pkidm.subject.EJBCATrustCenter;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectTrustCenterWithEJBCAServiceRequest
extends ServiceRequestBase
implements EJBCAServiceRequest {
    final Logger logger = LoggerFactory.getLogger(ConnectTrustCenterWithEJBCAServiceRequest.class);
    public static final String PROCESS = "ConnectTrustCenterWithEJBCAServiceRequest";
    private ConnectTrustCenterWithEJBCAServiceRequestContent content;

    public ConnectTrustCenterWithEJBCAServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    public EJBCATrustCenter getTrustCenter() {
        Long tId = this.getRecipientId();
        return (EJBCATrustCenter)PKIDMContext.getSubjectFactoryRegistry().getById(tId, EJBCATrustCenter.class);
    }

    public ConnectTrustCenterWithEJBCAServiceRequestContent getContent() {
        if (this.content == null) {
            this.content = (ConnectTrustCenterWithEJBCAServiceRequestContent)this.getContentView(ConnectTrustCenterWithEJBCAServiceRequestContent.class);
        }
        return this.content;
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        if (action.action.equals("action.importprofiles")) {
            return new ImportProfilesAction(this, action.user, this.getContent().name, this.getTrustCenter());
        }
        return null;
    }

    @Override
    public String getEJBCAURL() {
        Object url = this.getContent().url;
        url = (String)url + "/ejbcaws/ejbcaws?wsdl";
        return url;
    }
}

