/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.ejbca.connector.pkidm.action;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.ejbca.core.protocol.ws.client.gen.ApprovalException_Exception;
import org.ejbca.core.protocol.ws.client.gen.AuthorizationDeniedException_Exception;
import org.ejbca.core.protocol.ws.client.gen.CertificateResponse;
import org.ejbca.core.protocol.ws.client.gen.EjbcaException_Exception;
import org.ejbca.core.protocol.ws.client.gen.EjbcaWS;
import org.ejbca.core.protocol.ws.client.gen.NotFoundException_Exception;
import org.ejbca.core.protocol.ws.client.gen.UserDataVOWS;
import org.ejbca.core.protocol.ws.client.gen.UserDoesntFullfillEndEntityProfile_Exception;
import org.openscdp.ejbca.connector.pkidm.action.EJBCAAction;
import org.openscdp.ejbca.connector.pkidm.servicerequest.EJBCACertificateRequest;
import org.openscdp.pkidm.X509CertificateStore;
import org.openscdp.pkidm.action.ServiceRequestActionException;

public class EJBCACertificateRequestAction
extends EJBCAAction {
    public static final int CERT_REQ_TYPE_PKCS10 = 0;
    public static final String RESPONSETYPE_CERTIFICATE = "CERTIFICATE";
    public static final String ACTION = "action.approve";
    private EJBCACertificateRequest sr;
    private Long userId;

    public EJBCACertificateRequestAction(EJBCACertificateRequest serviceRequest, Long userId) {
        super(serviceRequest);
        this.sr = serviceRequest;
        this.userId = userId;
    }

    public void execute(SmartCardHSMProvider provider) {
        this.configureSSL(provider);
        this.requestCertificate();
    }

    private void requestCertificate() {
        EjbcaWS ejbca = this.getEjbcaWSPort();
        UserDataVOWS user = new UserDataVOWS();
        user.setUsername(this.sr.getUsername());
        user.setSubjectDN(this.sr.getSubjectDN());
        user.setCaName(this.sr.getCaName());
        user.setEmail(this.sr.getEmail());
        user.setSubjectAltName(this.sr.getSubjectAltName());
        user.setEndEntityProfileName(this.sr.getEndEntityProfileName());
        user.setCertificateProfileName(this.sr.getCertificateProfileName());
        try {
            String pem = this.getRequestAsPEM();
            CertificateResponse resp = ejbca.certificateRequest(user, pem, 0, null, RESPONSETYPE_CERTIFICATE);
            System.out.println("Certificate Response Type: " + resp.getResponseType());
            System.out.println("Certificate Response: " + resp.getData().length);
            pem = new String(resp.getData());
            System.out.println(pem);
            this.importCertificate(resp.getData());
        }
        catch (IOException | ApprovalException_Exception | AuthorizationDeniedException_Exception | EjbcaException_Exception | NotFoundException_Exception | UserDoesntFullfillEndEntityProfile_Exception e) {
            throw new ServiceRequestActionException("EJBCACertificateRequestAction failed (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
    }

    private String getRequestAsPEM() throws IOException {
        PKCS10CertificationRequest pkcs10 = new PKCS10CertificationRequest(this.sr.getPKCS10Request());
        StringWriter strWriter = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)strWriter);
        pemWriter.writeObject((Object)pkcs10);
        pemWriter.close();
        return strWriter.toString();
    }

    private void importCertificate(byte[] base64) {
        try {
            X509Certificate certificate = X509CertificateStore.toX509Certificate((byte[])base64);
            X509CertificateStore.importCertificate((X509Certificate)certificate, (Long)this.sr.getOriginatorId(), (boolean)true, (long)this.sr.getId());
            this.sr.setStatusInfo("Certificate issued");
            this.sr.setLifeCycle(7);
            this.sr.setRoleId(null);
            this.sr.commit(this.userId, null);
        }
        catch (CertificateException e) {
            throw new ServiceRequestActionException("Certificate processing failed  (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
    }
}

