/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.ejbca.connector;

import de.cardcontact.opencard.factory.SmartCardHSMCardServiceFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.OpenCardPropertyLoadingException;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.openscdp.ejbca.connector.pkidm.servicerequest.ConnectTrustCenterWithEJBCAServiceRequest;
import org.openscdp.ejbca.connector.pkidm.servicerequest.EJBCACertificateServiceRequest;
import org.openscdp.ejbca.connector.pkidm.subject.EJBCASubject;
import org.openscdp.ejbca.connector.pkidm.subject.EJBCATrustCenter;
import org.openscdp.pkicard.ServiceRequestCardSessionFactory;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.X509ServiceRequests;
import org.openscdp.pkidm.X509Subjects;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactory;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactoryBase;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactoryRegistry;
import org.openscdp.pkidm.subject.SubjectFactory;
import org.openscdp.pkidm.subject.SubjectFactoryBase;
import org.openscdp.pkidm.subject.SubjectFactoryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EJBCAConnectorServletContextListener
implements ServletContextListener {
    final Logger logger = LoggerFactory.getLogger(EJBCAConnectorServletContextListener.class);
    public static final String ATTRIBUTE_PKIDM = "PKIDM";
    Jdbi jdbi;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        String url = ctx.getInitParameter("database.url");
        String user = ctx.getInitParameter("database.user");
        String password = ctx.getInitParameter("database.password");
        Jdbi jdbi = Jdbi.create((String)url, (String)user, (String)password);
        jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        try {
            System.setProperty("OpenCard.loaderClassName", "");
            SmartCard.start();
            CardServiceRegistry csr = CardServiceRegistry.getRegistry();
            SmartCardHSMCardServiceFactory csf = new SmartCardHSMCardServiceFactory();
            csr.add((CardServiceFactory)csf);
        }
        catch (OpenCardPropertyLoadingException e) {
            this.logger.error("Error loading Opencard properties", (Throwable)e);
        }
        catch (CardServiceException e) {
            this.logger.error("Error creating card service", (Throwable)e);
        }
        catch (CardTerminalException e) {
            this.logger.error("Error creating terminal service", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Terminal or service factory not found", (Throwable)e);
        }
        ctx.setAttribute("cardSessionFactory", (Object)new ServiceRequestCardSessionFactory());
        PKIDMContext.setJDBI((Jdbi)jdbi);
        X509ServiceRequests.addServiceRequestFactories((Jdbi)jdbi);
        X509Subjects.addSubjectFactories((Jdbi)jdbi);
        ServiceRequestFactoryRegistry registry = PKIDMContext.getServiceRequestFactoryRegistry();
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(ConnectTrustCenterWithEJBCAServiceRequest.class));
        registry.addServiceRequestFactory((ServiceRequestFactory)new ServiceRequestFactoryBase(EJBCACertificateServiceRequest.class));
        SubjectFactoryRegistry subjectFactory = PKIDMContext.getSubjectFactoryRegistry();
        subjectFactory.addSubjectFactory((SubjectFactory)new SubjectFactoryBase(EJBCASubject.class));
        subjectFactory.addSubjectFactory((SubjectFactory)new SubjectFactoryBase(EJBCATrustCenter.class));
        ctx.setAttribute(ATTRIBUTE_PKIDM, (Object)PKIDMContext.getInstance());
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        PKIDMContext pkidmctx = (PKIDMContext)ctx.getAttribute(ATTRIBUTE_PKIDM);
        if (pkidmctx != null) {
            ctx.removeAttribute(ATTRIBUTE_PKIDM);
        }
    }
}

