/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc.action;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificateGenerator;
import de.cardcontact.opencard.eac.cvc.CertificateEffectiveDate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderAuthorizationTemplate;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.Extensions;
import de.cardcontact.tlv.ObjectIdentifier;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.time.LocalDate;
import java.util.LinkedList;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestActionStates;
import org.openscdp.pkidm.cvc.CVCSigner;
import org.openscdp.pkidm.cvc.CVCTools;
import org.openscdp.pkidm.holder.CVCertificateHolder;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateError;
import org.openscdp.pkidm.signer.HSMSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IssueCVCertificateAction<T extends ServiceRequest>
implements ServiceRequestAction {
    private final Logger logger = LoggerFactory.getLogger(IssueCVCertificateAction.class);
    protected T serviceRequest;
    protected Long issuerId;
    protected Long holderId;
    protected CVCertificateHolder issuer;
    protected CVCertificateHolder holder;
    protected CardVerifiableCertificate request;
    protected byte[] relativeAuthorization = new byte[1];
    protected int certificateValidityDays = 2;
    protected Extensions extensions = null;

    public IssueCVCertificateAction(T serviceRequest) {
        this.serviceRequest = serviceRequest;
    }

    @Override
    public String getKey() {
        return null;
    }

    public T getServiceRequest() {
        return this.serviceRequest;
    }

    public boolean preFlightCheck() {
        return true;
    }

    public boolean isReady() {
        CVCSigner signer = this.issuer.getSigner();
        if (signer == null) {
            return false;
        }
        if (signer.getStatus() != HSMSigner.Status.READY) {
            this.serviceRequest.setActionInfo("Token with signer is not online");
            return false;
        }
        return true;
    }

    private void validateCertificate(CardVerifiableCertificate cvc) {
        LinkedList<CardVerifiableCertificate> chain = this.issuer.getCertificateChain();
        chain.add(0, cvc);
        try {
            CVCTools.validateChain(chain);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Certificate chain did not validate. Database inconsistent", e);
        }
    }

    public CardVerifiableCertificate issueCertificate() throws GeneralSecurityException {
        CVCSigner signer = this.issuer.getSigner();
        PrivateKey signingKey = (PrivateKey)signer.getKey();
        CVCertificateGenerator gen = new CVCertificateGenerator((Provider)signer.getProvider());
        CertificateEffectiveDate notBefore = new CertificateEffectiveDate(LocalDate.now());
        gen.setCertificateEffectiveDate(notBefore);
        LocalDate notAfter = LocalDate.now().plusDays(this.certificateValidityDays);
        CardVerifiableCertificate issuerCert = this.issuer.getCurrentCertificate();
        LocalDate issuerNotAfter = issuerCert.getCertificateExpirationDate();
        if (notAfter.isAfter(issuerNotAfter)) {
            notAfter = issuerNotAfter;
        }
        CertificateExpirationDate cxd = new CertificateExpirationDate(notAfter);
        gen.setCertificateExpirationDate(cxd);
        CertificationAuthorityReference car = new CertificationAuthorityReference(issuerCert.getCertificateHolderReference().toString());
        gen.setCertificationAuthorityReference(car);
        gen.setCertificateHolderReference(this.request.getCertificateHolderReference());
        ObjectIdentifier oid = issuerCert.getCertificateHolderAuthorizationTemplate().getOID();
        CertificateHolderAuthorizationTemplate chat = new CertificateHolderAuthorizationTemplate(oid, this.relativeAuthorization);
        gen.setCertificateHolderAuthorizationTemplate(chat);
        gen.setPublicKey(this.request.getPublicKey(), issuerCert.getPublicKeyOID());
        gen.setExtensions(this.extensions);
        String signAlgo = CardVerifiableCertificate.signAlgoForOID((ObjectIdentifier)issuerCert.getPublicKeyOID());
        CVCertificate tlv = gen.generate(signingKey, signAlgo);
        CardVerifiableCertificate cvc = new CardVerifiableCertificate(tlv.getBytes());
        this.validateCertificate(cvc);
        return cvc;
    }

    protected ServiceRequestStateContent postProcess(CardVerifiableCertificate cert) throws Exception {
        return null;
    }

    @Override
    public JSONActionResult execute() {
        try {
            if (!this.preFlightCheck() || !this.isReady()) {
                throw new ServiceRequestActionException("Precondition for service request not fulfilled");
            }
            CardVerifiableCertificate cert = this.issueCertificate();
            ServiceRequestStateContent content = this.postProcess(cert);
            this.serviceRequest.commit(content);
        }
        catch (Exception e) {
            this.logger.error("Certificate issuing failed", (Throwable)e);
            this.serviceRequest.setStatusInfo("Certification failed");
            this.serviceRequest.commit(new ServiceRequestStateError(e.getMessage()));
            return new JSONActionResult(ServiceRequestActionStates.FAILED, e.getMessage());
        }
        return new JSONActionResult(ServiceRequestActionStates.COMPLETED, "Certificate issued");
    }
}

