/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.escrow.send;

import de.cardcontact.opencard.service.isocard.CHVCardServiceWithControl;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.Key;
import java.security.cert.CertPathBuilderException;
import java.util.List;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkicard.escrow.SmartCardHSMCertificateChainTLV;
import org.openscdp.pkicard.escrow.XKEKKeyDomain;
import org.openscdp.pkicard.escrow.send.SendKeyToEscrowContent;
import org.openscdp.pkicard.escrow.send.SendKeyToEscrowSharedServiceRequest;
import org.openscdp.pkidb.dao.KeyEscrowDAO;
import org.openscdp.pkidb.dto.KeyEscrowDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.holder.escrow.KeyEscrow;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendKeyToEscrowAction
extends ServiceRequestSmartCardHSMAction {
    private final Logger logger = LoggerFactory.getLogger(SendKeyToEscrowAction.class);
    public static final String ACTION = "action.kess.sendtoescrow";
    private SendKeyToEscrowSharedServiceRequest serviceRequest;
    private XKEKKeyDomain sourceXKD;
    private SendKeyToEscrowContent content;
    private String tokenPath;
    private List<String> aliases;

    public SendKeyToEscrowAction(SendKeyToEscrowSharedServiceRequest serviceRequest) {
        super(ACTION, (ServiceRequest)serviceRequest);
        this.serviceRequest = serviceRequest;
        String lastSeenAt = serviceRequest.getBackendConnectedTo();
        if (lastSeenAt != null) {
            this.context = "@" + lastSeenAt;
        }
    }

    public String getKey() {
        return ACTION;
    }

    public SendKeyToEscrowSharedServiceRequest getServiceRequest() {
        return this.serviceRequest;
    }

    public boolean preFlightCheck() {
        this.content = this.serviceRequest.getContent();
        this.tokenPath = this.content.getTokenPath();
        if (this.tokenPath == null) {
            return false;
        }
        this.aliases = this.serviceRequest.getContent().aliases;
        return this.aliases != null && this.aliases.size() != 0;
    }

    protected void assertReady(SmartCardHSMProvider provider) throws OpenCardException, CertPathBuilderException {
        if (!this.preFlightCheck()) {
            throw new ServiceRequestActionException("Precondition for service request not fulfilled");
        }
        SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
        if (!service.getId().equals(this.tokenPath)) {
            throw new ServiceRequestActionException("Wrong Token presented");
        }
        try {
            if (provider.getSmartCardHSMCardService().getPasswordStatus(null, 1) != CHVCardServiceWithControl.PasswordStatus.VERIFIED) {
                throw new ServiceRequestActionException("Token " + this.tokenPath + " is not authenticated");
            }
        }
        catch (CardServiceException | CardTerminalException e) {
            this.logger.error("Device error", e);
            throw new ServiceRequestActionException("Error while processing token " + this.tokenPath, e);
        }
    }

    private void prepareKeyDomain(SmartCardHSMProvider provider) {
        KeyEscrow keyEscrow = this.serviceRequest.getKeyEscrowHolder();
        byte[] kdUID = keyEscrow.getSigner().getKeyDomain();
        this.sourceXKD = new XKEKKeyDomain(provider, kdUID);
        this.sourceXKD.generateExportKey(keyEscrow.getName());
        this.sourceXKD.deriveXKEKWith(keyEscrow.getCertificateChain());
    }

    private void sendToEscrow(String name, Long escrowSignerId) {
        SmartCardHSMKey key = this.sourceXKD.getKey(name);
        try (Handle handle = PKIDMContext.getJDBI().open();){
            KeyEscrowDAO escrowDAO = (KeyEscrowDAO)handle.attach(KeyEscrowDAO.class);
            KeyEscrowDTO dto = escrowDAO.getKeyEscrowBySignerAndKeyId(escrowSignerId, key.getKeyId());
            if (dto != null) {
                this.logger.debug("Key " + name + " already in escrow");
                return;
            }
            byte[] wrappedKey = this.sourceXKD.wrapKey((Key)key);
            SmartCardHSMCertificateChainTLV exportChain = this.sourceXKD.getEphemeralChain();
            dto = new KeyEscrowDTO(null, escrowSignerId, key.getKeyId(), name, exportChain.getBytes(), wrappedKey);
            escrowDAO.create(dto);
        }
        catch (Exception e) {
            this.logger.error("Send key to escrow failed", (Throwable)e);
            throw new ServiceRequestActionException("Send key to escrow failed", (Throwable)e);
        }
    }

    @Override
    public JSONActionResult execute() {
        String lastSeenAt = this.serviceRequest.getBackendConnectedTo();
        if (lastSeenAt == null) {
            return this.getStatus();
        }
        return this.execute(this.serviceRequest.getContent().getTokenPath());
    }

    @Override
    public void execute(SmartCardHSMProvider provider) {
        try {
            this.assertReady(provider);
            this.prepareKeyDomain(provider);
            Long escrowSignerId = this.serviceRequest.getKeyEscrowHolder().getSigner().getId();
            for (String alias : this.aliases) {
                this.sendToEscrow(alias, escrowSignerId);
            }
            this.sourceXKD.deleteEphemeralKey();
            this.serviceRequest.setStatusInfo("Send to escrow");
            this.serviceRequest.setLifeCycle(11);
            this.serviceRequest.setRoleId(null);
        }
        catch (ServiceRequestActionException srae) {
            throw srae;
        }
        catch (Exception e) {
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }
}

