/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.action;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.TokenActionDAO;
import org.openscdp.pkidb.dto.TokenActionDTO;
import org.openscdp.pkidm.PKIDMContext;

public class TokenActionScheduler {
    public static Long schedule(Long serviceRequestId, Long tokenId) {
        Long id = null;
        try (Handle handle = PKIDMContext.getJDBI().open();){
            TokenActionDAO tokenActionDAO = (TokenActionDAO)handle.attach(TokenActionDAO.class);
            List dtos = tokenActionDAO.getTokenActionList(tokenId);
            boolean pending = false;
            for (TokenActionDTO dto : dtos) {
                if (!dto.getServiceRequestId().equals(serviceRequestId)) continue;
                pending = true;
                id = dto.getId();
                break;
            }
            if (!pending) {
                TokenActionDTO dto = new TokenActionDTO(tokenId, serviceRequestId);
                id = tokenActionDAO.create(dto);
            }
        }
        return id;
    }
}

