/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.tlv;

import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.ParseBuffer;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import de.cardcontact.tlv.Tag;

public class Sequence
extends ConstructedTLV {
    public Sequence() {
        super(new Tag(16, 0, true));
    }

    public Sequence(ParseBuffer pb) throws TLVEncodingException {
        super(pb);
        if (this.tag.getNumber() != 16 || !this.tag.isConstructed()) {
            throw new TLVEncodingException("Invalid tag for SEQUENCE");
        }
    }

    public Sequence(TLV tlv) throws TLVEncodingException {
        super(tlv);
    }

    public static Sequence getInstance(TLV tlv, Tag et) throws TLVEncodingException {
        if (!tlv.getTag().equals(et)) {
            throw new TLVEncodingException("Tag must be " + String.valueOf(et));
        }
        if (tlv instanceof Sequence) {
            return (Sequence)tlv;
        }
        return new Sequence(tlv);
    }

    public static Sequence getInstance(TLV tlv) throws TLVEncodingException {
        return Sequence.getInstance(tlv, Tag.TAG_SEQUENCE);
    }
}

