/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.ejbca.connector.pkidm.action;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.beans.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.util.encoders.Base64;
import org.ejbca.core.protocol.ws.client.gen.AuthorizationDeniedException_Exception;
import org.ejbca.core.protocol.ws.client.gen.CADoesntExistsException_Exception;
import org.ejbca.core.protocol.ws.client.gen.Certificate;
import org.ejbca.core.protocol.ws.client.gen.EjbcaException_Exception;
import org.ejbca.core.protocol.ws.client.gen.EjbcaWS;
import org.ejbca.core.protocol.ws.client.gen.NameAndId;
import org.ejbca.core.protocol.ws.client.gen.UnknownProfileTypeException_Exception;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.ejbca.connector.pkidm.action.EJBCAAction;
import org.openscdp.ejbca.connector.pkidm.action.IssuerNotFoundException;
import org.openscdp.ejbca.connector.pkidm.servicerequest.EJBCAServiceRequest;
import org.openscdp.ejbca.connector.pkidm.signer.EJBCAProfile;
import org.openscdp.ejbca.connector.pkidm.signer.EJBCAProfileContent;
import org.openscdp.ejbca.connector.pkidm.signer.EJBCAProfileGenerator;
import org.openscdp.ejbca.connector.pkidm.subject.EJBCASubject;
import org.openscdp.ejbca.connector.pkidm.subject.EJBCASubjectContent;
import org.openscdp.ejbca.connector.pkidm.subject.EJBCASubjectGenerator;
import org.openscdp.ejbca.connector.pkidm.subject.EJBCATrustCenter;
import org.openscdp.pkidb.dao.RoleDAO;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.AssignedRoleDTO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.RoleDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.X509CertificateStore;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.subject.SubjectFactoryRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportProfilesAction
extends EJBCAAction {
    final Logger logger = LoggerFactory.getLogger(ImportProfilesAction.class);
    private EJBCAServiceRequest sr;
    private Long userId;
    private String name;
    private EJBCATrustCenter tc;
    public static final String ACTION = "action.importprofiles";

    public ImportProfilesAction(EJBCAServiceRequest serviceRequest, Long userId, String name, EJBCATrustCenter trustCenter) {
        super(serviceRequest);
        this.sr = serviceRequest;
        this.userId = userId;
        this.name = name;
        this.tc = trustCenter;
    }

    public void execute(SmartCardHSMProvider provider) {
        this.configureSSL(provider);
        this.importProfile();
    }

    private void importProfile() {
        EjbcaWS ejbca = this.getEjbcaWSPort();
        EJBCASubject subject = this.getSubject();
        try {
            List<NameAndId> eeps = ejbca.getAuthorizedEndEntityProfiles();
            for (NameAndId eep : eeps) {
                System.out.println("Authorized End Entity Profile ID: " + eep.getId() + ", Name:" + eep.getName());
                String eepRoleName = subject.getName() + "/eep/" + eep.getName();
                long roleId = this.createRole(eepRoleName, this.sr.getId(), this.userId);
                List<NameAndId> cas = ejbca.getAvailableCAsInProfile(eep.getId());
                for (NameAndId ca : cas) {
                    CertificateDTO caCert;
                    System.out.println("CA ID: " + ca.getId() + ", Name:" + ca.getName());
                    List<Certificate> chain = ejbca.getLastCAChain(ca.getName());
                    try {
                        caCert = this.importCertificateChain(chain, subject.getId());
                    }
                    catch (CertificateException e) {
                        byte[] base64 = chain.get(0).getCertificateData();
                        byte[] decodedBytes = Base64.decode((byte[])base64);
                        CardVerifiableCertificate cvc = new CardVerifiableCertificate(decodedBytes);
                        this.logger.debug(cvc.toString());
                        this.logger.warn("Skip CVC CA " + ca.getName() + " (SR-ID: " + this.sr.getId() + ")", (Throwable)e);
                        continue;
                    }
                    catch (IssuerNotFoundException e) {
                        this.logger.warn("Skip import of CA " + ca.getName() + ": " + e.getMessage() + " (SR-ID: " + this.sr.getId() + ")", (Throwable)((Object)e));
                        continue;
                    }
                    catch (ServiceRequestActionException e) {
                        String msg = "Failed to import CA " + ca.getName() + ": " + e.getMessage();
                        this.logger.error("ImportProfilesAction failed (SR-ID: " + this.sr.getId() + "): " + msg);
                        throw new ServiceRequestActionException(msg, (Throwable)e);
                    }
                    List<NameAndId> cps = ejbca.getAvailableCertificateProfiles(eep.getId());
                    for (NameAndId cp : cps) {
                        EJBCAProfile profile;
                        System.out.println("Certificate Profile ID: " + cp.getId() + ", Name:" + cp.getName());
                        EJBCAProfileContent content = new EJBCAProfileContent();
                        content.eepName = eep.getName();
                        content.eepId = eep.getId();
                        content.eepRoleId = roleId;
                        content.cpName = cp.getName();
                        content.cpId = cp.getId();
                        byte[] p = ejbca.getProfile(cp.getId(), "cp");
                        this.copyCertificatePolicy(p, content);
                        String profileName = content.eepName + "/" + content.cpName;
                        Jdbi jdbi = PKIDMContext.getJDBI();
                        SignerDTO dto = null;
                        try (Handle handle = jdbi.open();){
                            SignerDAO dao = (SignerDAO)handle.attach(SignerDAO.class);
                            dto = dao.getSignerByHolderAndName(caCert.getHolderId(), profileName);
                        }
                        if (dto != null) {
                            profile = new EJBCAProfile(dto);
                            profile.setContent(content);
                            profile.commit();
                            this.sr.setStatusInfo("EJBCA Profile updated");
                            continue;
                        }
                        EJBCAProfileGenerator gen = new EJBCAProfileGenerator(caCert.getHolderId(), profileName);
                        gen.setContent(content);
                        profile = gen.generate();
                        this.sr.setStatusInfo("EJBCA Profile created");
                    }
                }
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException | CertificateException | AuthorizationDeniedException_Exception | CADoesntExistsException_Exception | EjbcaException_Exception | UnknownProfileTypeException_Exception e) {
            throw new ServiceRequestActionException("ImportProfilesAction failed (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
    }

    private EJBCASubject getSubject() {
        SubjectFactoryRegistry subFactory = PKIDMContext.getSubjectFactoryRegistry();
        EJBCASubject subject = null;
        try {
            subject = (EJBCASubject)subFactory.getByName(this.name, "EJBCA", EJBCASubject.class);
        }
        catch (RuntimeException e) {
            this.logger.info("Subject not found", (Throwable)e);
        }
        if (subject == null) {
            subject = this.createSubject();
        }
        return subject;
    }

    private EJBCASubject createSubject() {
        EJBCASubjectGenerator gen = new EJBCASubjectGenerator(this.name, this.sr.getId(), this.tc.getOperatorRoleId());
        EJBCASubjectContent content = new EJBCASubjectContent();
        content.url = this.sr.getEJBCAURL();
        gen.setContent(content);
        EJBCASubject subject = gen.generate();
        this.tc.getEjbcaSubjectIds().add(subject.getId());
        this.tc.commit();
        return subject;
    }

    private long createRole(String name, long srId, long subjectId) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            Long roleId;
            RoleDAO roleDAO = (RoleDAO)handle.attach(RoleDAO.class);
            RoleDTO role = roleDAO.getRole(name);
            if (role == null) {
                role = new RoleDTO();
                role.setName(name);
                roleId = roleDAO.insert(role);
                roleDAO.updateManagingRoleId(roleId, roleId);
            } else {
                roleId = role.getId();
            }
            AssignedRoleDTO assignedRole = roleDAO.getAssignedRole(subjectId, roleId.longValue());
            if (assignedRole == null) {
                assignedRole = new AssignedRoleDTO();
                assignedRole.setRoleId(roleId);
                assignedRole.setServiceRequestId(Long.valueOf(srId));
                assignedRole.setSubjectId(Long.valueOf(subjectId));
                roleDAO.insert(assignedRole);
            }
            long l = roleId;
            return l;
        }
    }

    private CertificateDTO importCertificateChain(List<Certificate> chain, long subjectId) throws CertificateException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException {
        this.logger.debug("Import #" + chain.size() + " certificates");
        X509Certificate[] certs = new X509Certificate[chain.size()];
        CertificateDTO certDTO = null;
        for (int i = certs.length - 1; i >= 0; --i) {
            PublicKey verificationKey;
            X509Certificate certificate = X509CertificateStore.toX509Certificate((byte[])Base64.decode((byte[])chain.get(i).getCertificateData()));
            this.logger.debug(certificate.toString());
            if (i == certs.length - 1) {
                X500Principal issuerDN;
                X500Principal subjectDN = certificate.getSubjectX500Principal();
                if (!subjectDN.equals(issuerDN = certificate.getIssuerX500Principal())) {
                    throw new IssuerNotFoundException("Issuer " + String.valueOf(issuerDN) + " not found");
                }
                verificationKey = certificate.getPublicKey();
            } else {
                verificationKey = certs[i + 1].getPublicKey();
            }
            try {
                certificate.verify(verificationKey);
            }
            catch (SignatureException e) {
                throw new ServiceRequestActionException("Failed to verify CA certificate " + String.valueOf(certificate.getSubjectX500Principal()) + " issued by " + String.valueOf(certificate.getIssuerX500Principal()), (Throwable)e);
            }
            Long subjectRef = null;
            if (i == 0) {
                subjectRef = subjectId;
            }
            certDTO = X509CertificateStore.importCertificate((X509Certificate)certificate, (Long)subjectRef, (boolean)true, (long)this.sr.getId());
            certs[i] = certificate;
        }
        return certDTO;
    }

    private void copyCertificatePolicy(byte[] encodedCertificatePolicy, EJBCAProfileContent content) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(encodedCertificatePolicy);
            try (XMLDecoder decoder = new XMLDecoder(bis);){
                Object o = decoder.readObject();
                if (o instanceof LinkedHashMap) {
                    LinkedHashMap hm = (LinkedHashMap)o;
                    content.availablekeyalgorithms = (ArrayList)hm.get("availablekeyalgorithms");
                    content.availableeccurves = (ArrayList)hm.get("availableeccurves");
                    content.availablebitlengths = (ArrayList)hm.get("availablebitlengths");
                }
            }
        }
        catch (Exception e) {
            throw new ServiceRequestActionException("ImportProfilesAction failed (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
    }
}

