/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkiapi.subject;

import com.fasterxml.jackson.databind.JsonNode;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.core.Response;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertPathBuilderException;
import java.util.List;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkiapi.subject.GetPKAChallengeResponse;
import org.openscdp.pkiapi.subject.GetTokenListResponse;
import org.openscdp.pkiapi.subject.GetTokenResponse;
import org.openscdp.pkiapi.subject.PKAStatus;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.subject.Subject;
import org.openscdp.pkidm.subject.SubjectFactoryRegistry;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/subject")
public class SubjectResource {
    private final Logger logger = LoggerFactory.getLogger(SubjectResource.class);

    @GET
    @Path(value="/{id}/token")
    @Produces(value={"application/json"})
    public Response getTokenList(@PathParam(value="id") Long id, @HeaderParam(value="UserId") Long userId) {
        this.logger.debug("GET /subject/" + id + "/token");
        Subject subject = this.loadSubject(id, userId);
        List<TokenDTO> tokenList = this.loadTokenList(id);
        GetTokenListResponse rsp = new GetTokenListResponse(tokenList);
        return Response.ok((Object)rsp).build();
    }

    @GET
    @Path(value="/{id}/token/{tokenId}")
    @Produces(value={"application/json"})
    public Response getToken(@PathParam(value="id") Long id, @PathParam(value="tokenId") Long tokenId, @HeaderParam(value="UserId") Long userId) {
        this.logger.debug("GET /subject/" + id + "/token/" + tokenId);
        Subject subject = this.loadSubject(id, userId);
        TokenDTO token = this.loadToken(tokenId);
        if (token == null) {
            this.logger.error("Token " + id + " not found");
            throw new NotFoundException();
        }
        GetTokenResponse rsp = new GetTokenResponse(token);
        HSMService service = PKIDMContext.getHSMService();
        SmartCardHSMProvider hsm = service.getProvider(token.getPath());
        if (hsm != null) {
            rsp.updateTokenStatus(hsm.getSmartCardHSMCardService());
        }
        return Response.ok((Object)rsp).build();
    }

    @POST
    @Path(value="/{id}/token/{tokenId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response handlePost(@PathParam(value="id") Long id, @PathParam(value="tokenId") Long tokenId, @HeaderParam(value="UserId") Long userId, JSONAction action) {
        Object rsp;
        this.logger.debug("POST /subject/" + id + "/token/" + tokenId);
        Subject subject = this.loadSubject(id, userId);
        TokenDTO token = this.loadToken(tokenId);
        if (token == null) {
            this.logger.error("Token " + id + " not found");
            throw new NotFoundException();
        }
        HSMService service = PKIDMContext.getHSMService();
        SmartCardHSMProvider hsm = service.getProvider(token.getPath());
        if (hsm == null) {
            this.logger.error("HSM " + token.getPath() + " not online");
            throw new NotFoundException();
        }
        if (action.action.equals("pkaChallenge")) {
            rsp = this.getPKAChallenge(hsm);
        } else if (action.action.equals("externalAuthenticate")) {
            rsp = this.performExternalAuthentication(action, hsm.getSmartCardHSMCardService());
        } else {
            if (action.action.equals("logout")) {
                this.logout(hsm.getSmartCardHSMCardService());
                return Response.ok().build();
            }
            this.logger.error("Action " + action.action + " not supported for subject");
            throw new NotSupportedException();
        }
        return Response.ok((Object)rsp).build();
    }

    private GetPKAChallengeResponse getPKAChallenge(SmartCardHSMProvider hsm) {
        SecureRandom rng;
        try {
            rng = SecureRandom.getInstance("NativePRNG", (Provider)hsm);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new ServerErrorException(Response.serverError().build(), (Throwable)e);
        }
        byte[] challenge = new byte[8];
        rng.nextBytes(challenge);
        SmartCardHSMCardService cs = hsm.getSmartCardHSMCardService();
        GetPKAChallengeResponse rsp = new GetPKAChallengeResponse(challenge, cs.getDeviceId());
        return rsp;
    }

    private void logout(SmartCardHSMCardService cs) {
        try {
            cs.closeApplication(null);
            cs.initSecureMessaging();
        }
        catch (CertPathBuilderException | CardServiceException | CardTerminalException e) {
            e.printStackTrace();
            throw new ServerErrorException(Response.serverError().build(), e);
        }
    }

    private PKAStatus performExternalAuthentication(JSONAction action, SmartCardHSMCardService cs) {
        try {
            String chr = action.args.get("chr").textValue();
            cs.selectPubKeyForAuthentication(chr.getBytes());
            JsonNode value = action.args.get("signature");
            byte[] signature = HexString.parseHexString((String)value.textValue());
            boolean res = cs.externalAuthenticate(signature);
            return PKAStatus.getStatusFromService(cs);
        }
        catch (CardServiceException | CardTerminalException e) {
            e.printStackTrace();
            throw new ServerErrorException(Response.serverError().build(), e);
        }
    }

    private Subject loadSubject(Long id, Long userId) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            Subject subject;
            SubjectDAO dao = (SubjectDAO)handle.attach(SubjectDAO.class);
            SubjectDTO dto = dao.getSubject(id.longValue());
            if (dto == null) {
                this.logger.error("Subject " + id + " not found");
                throw new NotFoundException();
            }
            SubjectFactoryRegistry reg = PKIDMContext.getSubjectFactoryRegistry();
            if (!reg.isSupported(dto)) {
                this.logger.error("Service request " + id + " not support by API");
                throw new NotSupportedException();
            }
            Subject subject2 = subject = reg.getByDTO(dto);
            return subject2;
        }
    }

    private List<TokenDTO> loadTokenList(long id) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            List list;
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            List list2 = list = dao.getTokenList(Long.valueOf(id));
            return list2;
        }
    }

    private TokenDTO loadToken(long id) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO tokenDTO = dao.getToken(Long.valueOf(id));
            return tokenDTO;
        }
    }
}

