/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkiapi.subject;

import de.cardcontact.opencard.service.smartcardhsm.PublicKeyAuthenticationStatus;
import de.cardcontact.opencard.service.smartcardhsm.PublicKeyStatus;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import java.util.ArrayList;
import java.util.List;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;

public class PKAStatus {
    public Integer totalNumberOfPublicKeys;
    public Integer numberOfOutstandingPublicKeys;
    public Integer numberOfRequiredPublicKeysForAuthentication;
    public Integer numberOfAuthenticatedPublicKeys;
    public List<PublicKeyStatus> publicKeys;

    public PKAStatus(PublicKeyAuthenticationStatus pkaStatus, List<PublicKeyStatus> pkStatus) {
        this.totalNumberOfPublicKeys = pkaStatus.getTotalNumberOfPublicKeys();
        this.numberOfOutstandingPublicKeys = pkaStatus.getNumberOfOutstandingPublicKeys();
        this.numberOfRequiredPublicKeysForAuthentication = pkaStatus.getNumberOfRequiredPublicKeysForAuthentication();
        this.numberOfAuthenticatedPublicKeys = pkaStatus.getNumberOfAuthenticatedPublicKeys();
        this.publicKeys = pkStatus;
    }

    public static PKAStatus getStatusFromService(SmartCardHSMCardService cs) throws CardTerminalException, CardServiceException {
        PublicKeyAuthenticationStatus status = cs.getPublicKeyAuthenticationStatus();
        if (status == null) {
            return null;
        }
        ArrayList<PublicKeyStatus> publicKeys = new ArrayList<PublicKeyStatus>(status.getTotalNumberOfPublicKeys());
        for (int i = 0; i < status.getTotalNumberOfPublicKeys(); ++i) {
            publicKeys.add(cs.getPublicKeyStatus(i));
        }
        return new PKAStatus(status, publicKeys);
    }
}

