/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.dao;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.sqlobject.SqlObject;
import org.openscdp.pkidb.Filter;
import org.openscdp.pkidb.Order;

public interface FilteredQuery
extends SqlObject {
    default public String getWhereClauseFromFilter(List<Filter> filters) {
        Object where = "";
        if (filters == null) {
            return where;
        }
        if (!filters.isEmpty()) {
            where = " WHERE";
            for (int i = 0; i < filters.size(); ++i) {
                where = (String)where + " " + filters.get(i).getFilter();
                if (i >= filters.size() - 1) continue;
                where = (String)where + " AND";
            }
        }
        return where;
    }

    default public String getOrderByClause(List<Order> order) {
        Object orderBy = "";
        if (order == null) {
            return orderBy;
        }
        if (!order.isEmpty()) {
            orderBy = " ORDER BY";
            for (int i = 0; i < order.size(); ++i) {
                orderBy = (String)orderBy + " " + order.get(i).getValue();
                if (i >= order.size() - 1) continue;
                orderBy = (String)orderBy + ",";
            }
        }
        return orderBy;
    }

    default public Query getQuery(Handle handle, String sql, List<Filter> filters, List<Order> order, Long limit, Long offset) {
        if (filters != null) {
            sql = (String)sql + this.getWhereClauseFromFilter(filters);
        }
        if (order != null) {
            sql = (String)sql + this.getOrderByClause(order);
        }
        if (limit != null) {
            sql = (String)sql + " LIMIT " + limit;
        }
        if (offset != null) {
            sql = (String)sql + " OFFSET " + offset;
        }
        Query query = handle.createQuery((String)sql);
        int i = 0;
        for (Filter f : filters) {
            query = (Query)query.bind(i++, f.getValue());
        }
        return query;
    }
}

