/*
 * Decompiled with CFR 0.152.
 */
package opencard.core.terminal;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import opencard.core.terminal.CHVControl;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.InvalidSlotChannelException;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.Slot;
import opencard.core.terminal.SlotChannel;
import opencard.core.terminal.VerifiedAPDUInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CardTerminal {
    private static final Logger logger = LoggerFactory.getLogger(CardTerminal.class);
    private Vector channels = new Vector();
    @Deprecated
    protected Vector slots = new Vector();
    private int slotCount = 0;
    protected final String name;
    protected final String type;
    protected final String address;
    private Object ctListenerMonitor = new String("ctListenerMonitor");

    protected CardTerminal(String name, String type, String address) {
        logger.debug("[init] (" + name + ", " + type + ", " + address + ")");
        this.name = name;
        this.type = type;
        this.address = address;
    }

    @Deprecated
    public Enumeration enumerateSlots() {
        return this.slots.elements();
    }

    public final Properties features() {
        Properties features = new Properties();
        this.internalFeatures(features);
        if (features == null) {
            logger.debug("features implementation error in terminal class -> got 'null' instead of Enumeration object");
            features = new Properties();
        }
        features.put("name", this.getName());
        features.put("type", this.getType());
        features.put("address", this.getAddress());
        features.put("slots", String.valueOf(this.slotCount));
        return features;
    }

    public String getAddress() {
        return this.address;
    }

    public abstract CardID getCardID(int var1) throws CardTerminalException;

    @Deprecated
    public CardID getCardID(int slotID, int ms) throws CardTerminalException {
        return this.getCardID(slotID);
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public Slot getSlot(int slotID) throws IndexOutOfBoundsException {
        if (slotID >= this.slots.size()) {
            throw new IndexOutOfBoundsException("slotID too large");
        }
        return (Slot)this.slots.elementAt(slotID);
    }

    public String getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Slot[] slots() {
        Vector vector = this.slots;
        synchronized (vector) {
            Object[] result = new Slot[this.slots.size()];
            this.slots.copyInto(result);
            return result;
        }
    }

    public int getSlots() {
        return this.slotCount;
    }

    public abstract boolean isCardPresent(int var1) throws CardTerminalException;

    @Deprecated
    public boolean isCardPresent(Slot slot) throws CardTerminalException {
        return this.isCardPresent(slot.getSlotID());
    }

    public synchronized boolean isSlotChannelAvailable(int slotID) {
        return this.getSlotChannel(slotID) == null;
    }

    @Deprecated
    public synchronized boolean isSlotChannelAvailable(Slot slot) {
        return this.isSlotChannelAvailable(slot.getSlotID());
    }

    public abstract void open() throws CardTerminalException;

    public abstract void close() throws CardTerminalException;

    public final SlotChannel openSlotChannel(int slotID) throws InvalidSlotChannelException, IndexOutOfBoundsException, CardTerminalException {
        return this.openSlotChannel(slotID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SlotChannel openSlotChannel(int slotID, Object lockHandle) throws InvalidSlotChannelException, IndexOutOfBoundsException, CardTerminalException {
        logger.debug("[openSlotChannel] for slot #" + slotID);
        if (lockHandle == null) {
            this.internalOpenSlotChannel(slotID);
        } else {
            this.internalOpenSlotChannel(slotID, lockHandle);
        }
        if (slotID >= this.slots.size()) {
            throw new IndexOutOfBoundsException("slot id out of bounds");
        }
        SlotChannel channel = null;
        Vector vector = this.channels;
        synchronized (vector) {
            if (!this.isSlotChannelAvailable(slotID)) {
                throw new InvalidSlotChannelException("slot channel already allocated", this);
            }
            channel = new SlotChannel(this, slotID, lockHandle);
            this.channels.addElement(channel);
        }
        logger.debug("[openSlotChannel] new SlotChannel is " + String.valueOf(channel));
        return channel;
    }

    @Deprecated
    public final synchronized SlotChannel openSlotChannel(Slot slot) throws InvalidSlotChannelException, IndexOutOfBoundsException, CardTerminalException {
        return this.openSlotChannel(slot.getSlotID(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeSlotChannel(SlotChannel sc) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(sc);
        Vector vector = this.channels;
        synchronized (vector) {
            this.channels.removeElement(sc);
        }
        this.internalCloseSlotChannel(sc);
    }

    @Deprecated
    public final CardID reset(SlotChannel sc, int ms) throws InvalidSlotChannelException, CardTerminalException {
        return this.reset(sc);
    }

    public final CardID reset(SlotChannel sc) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(sc);
        return this.internalReset(sc.getSlotNumber(), -1);
    }

    public final CardID reset(SlotChannel sc, boolean warm) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(sc);
        return this.internalReset(sc.getSlotNumber(), warm);
    }

    public final ResponseAPDU sendAPDU(SlotChannel sc, CommandAPDU capdu) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(sc);
        return this.internalSendAPDU(sc.getSlotNumber(), capdu, -1);
    }

    @Deprecated
    public final ResponseAPDU sendAPDU(SlotChannel sc, CommandAPDU capdu, int ms) throws InvalidSlotChannelException, CardTerminalException {
        this.assertSlotChannelValid(sc);
        return this.internalSendAPDU(sc.getSlotNumber(), capdu, ms);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(super.toString()).append("\n");
        result.append("+ name    ").append(this.name).append("\n");
        result.append("+ type    ").append(this.type).append("\n");
        result.append("+ addr    ").append(this.address);
        return result.toString();
    }

    protected void addSlots(int numberOfSlots) throws CardTerminalException {
        this.slotCount += numberOfSlots;
        for (int i = 0; i < numberOfSlots; ++i) {
            this.slots.addElement(new Slot(this, i));
        }
        this.slots.trimToSize();
    }

    protected void cardRemoved(int slotID) {
        logger.debug("[cardRemoved] slotID " + slotID);
        CardTerminalRegistry.getRegistry().cardRemoved(this, slotID);
    }

    protected void cardInserted(int slotID) {
        logger.debug("[cardInserted] slotID " + slotID + ", )");
        CardTerminalRegistry.getRegistry().cardInserted(this, slotID);
    }

    protected Properties internalFeatures(Properties features) {
        return features;
    }

    protected void internalOpenSlotChannel(int slotID) throws CardTerminalException {
    }

    protected void internalOpenSlotChannel(int slotID, Object lockHandle) throws CardTerminalException {
        this.internalOpenSlotChannel(slotID);
    }

    protected void internalCloseSlotChannel(SlotChannel sc) throws CardTerminalException {
    }

    protected abstract CardID internalReset(int var1, int var2) throws CardTerminalException;

    protected CardID internalReset(int slot, boolean warm) throws CardTerminalException {
        return this.internalReset(slot, -1);
    }

    protected abstract ResponseAPDU internalSendAPDU(int var1, CommandAPDU var2, int var3) throws CardTerminalException;

    private void assertSlotChannelValid(SlotChannel sc) throws InvalidSlotChannelException {
        if (this.getSlotChannel(sc.getSlotNumber()) != sc) {
            throw new InvalidSlotChannelException("illegal SlotChannel", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SlotChannel getSlotChannel(int slotID) {
        Vector vector = this.channels;
        synchronized (vector) {
            Enumeration channs = this.channels.elements();
            while (channs.hasMoreElements()) {
                SlotChannel channel = (SlotChannel)channs.nextElement();
                if (channel.getSlotNumber() != slotID) continue;
                return channel;
            }
        }
        return null;
    }

    public ResponseAPDU sendVerifiedCommandAPDU(SlotChannel chann, CommandAPDU capdu, CHVControl vc, int ms) throws CardTerminalException {
        VerifiedAPDUInterface v = (VerifiedAPDUInterface)((Object)this);
        return v.sendVerifiedCommandAPDU(chann, capdu, vc);
    }
}

