/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.signer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.SignerDAO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.signer.Signer;
import org.openscdp.pkidm.signer.SignerContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerBase
implements Signer {
    final Logger logger = LoggerFactory.getLogger(SignerBase.class);
    static final ObjectMapper om = new ObjectMapper();
    protected SignerDTO dto;

    public SignerBase(SignerDTO dto) {
        this.dto = dto;
    }

    public Long getId() {
        return this.dto.getId();
    }

    public String getName() {
        return this.dto.getName();
    }

    public byte[] getKeyDomain() {
        return this.dto.getKeyDomain();
    }

    public byte[] getKeyId() {
        return this.dto.getKeyId();
    }

    protected <T extends SignerContent> T parseContent(Class<T> clazz) {
        try {
            String content = this.dto.getContent();
            if (content == null) {
                content = "{}";
            }
            return (T)((SignerContent)om.readValue(content, clazz));
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse content field", (Throwable)e);
            throw new RuntimeException("Failed to parse content field", e);
        }
    }

    public void setContent(SignerContent content) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            jsonstr = om.writeValueAsString((Object)content);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
    }

    public void updateContent(SignerContent view) {
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            String content = this.dto.getContent();
            if (content == null) {
                content = "{}";
            }
            JsonNode contentTree = om.readTree(content);
            JsonNode update = om.valueToTree((Object)view);
            Iterator fields = update.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                if (contentTree.has((String)field.getKey())) {
                    ((ObjectNode)contentTree).replace((String)field.getKey(), (JsonNode)field.getValue());
                    continue;
                }
                if (((JsonNode)field.getValue()).isNull()) continue;
                ((ObjectNode)contentTree).set((String)field.getKey(), (JsonNode)field.getValue());
            }
            String jsonstr = om.writeValueAsString((Object)contentTree);
            this.dto.setContent(jsonstr);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error updating content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
    }

    public void commit() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            SignerDAO dao = (SignerDAO)handle.attach(SignerDAO.class);
            dao.update(this.dto);
        }
    }
}

