/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.servicerequest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestContent;
import org.openscdp.pkidm.servicerequest.ServiceRequestContentView;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceRequestBase
implements ServiceRequest {
    final Logger logger = LoggerFactory.getLogger(ServiceRequestBase.class);
    static final ObjectMapper om = new ObjectMapper();
    protected ServiceRequestDTO dto;
    protected Long userId;
    protected Long roleId;
    protected String actionInfo;
    private JsonNode contentTree;

    protected ServiceRequestBase(ServiceRequestDTO dto) {
        this.dto = dto;
    }

    @Override
    public Long getId() {
        return this.dto.getId();
    }

    @Override
    public ServiceRequestDTO getDTO() {
        return this.dto;
    }

    @Override
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @Override
    public JsonNode getContentTree() {
        if (this.contentTree == null) {
            try {
                this.contentTree = om.readTree(this.dto.getContent());
            }
            catch (JsonProcessingException e) {
                this.logger.error("Failed to parse content field", (Throwable)e);
                throw new RuntimeException("Failed to parse content field", e);
            }
        }
        return this.contentTree;
    }

    protected <T extends ServiceRequestContent> T getContentView(Class<T> clazz) {
        try {
            JsonNode ct = this.getContentTree();
            return (T)((ServiceRequestContent)om.treeToValue((TreeNode)ct, clazz));
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse content field", (Throwable)e);
            throw new RuntimeException("Failed to parse content field", e);
        }
    }

    public void setContent(ServiceRequestContent content) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            this.contentTree = om.valueToTree((Object)content);
            jsonstr = om.writeValueAsString((Object)this.contentTree);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
    }

    @Override
    public void updateContent(ServiceRequestContentView view) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            JsonNode update = om.valueToTree((Object)view);
            Iterator fields = update.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                if (this.contentTree.has((String)field.getKey())) {
                    ((ObjectNode)this.contentTree).replace((String)field.getKey(), (JsonNode)field.getValue());
                    continue;
                }
                if (((JsonNode)field.getValue()).isNull()) continue;
                ((ObjectNode)this.contentTree).set((String)field.getKey(), (JsonNode)field.getValue());
            }
            jsonstr = om.writeValueAsString((Object)this.contentTree);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
    }

    public abstract ServiceRequestContent getContent();

    @Override
    public void setStatusInfo(String info) {
        this.dto.setState(info);
    }

    @Override
    public void updateDetails(String details) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dao.updateDetails(details, this.getId());
        }
    }

    @Override
    public int getLifeCycle() {
        return this.dto.getLifecycle();
    }

    @Override
    public void setLifeCycle(int state) {
        this.dto.setLifecycle(Integer.valueOf(state));
    }

    @Override
    public void setRoleId(Long roleId) {
        this.dto.setAssignedToRole(roleId);
    }

    @Override
    public Long getOriginatorId() {
        return this.dto.getOriginatorId();
    }

    @Override
    public Long getRecipientId() {
        return this.dto.getRecipientId();
    }

    @Override
    public ServiceRequestAction getActionFor(JSONAction action) {
        return null;
    }

    @Override
    public void setActionInfo(String info) {
        this.actionInfo = info;
    }

    @Override
    public String getActionInfo() {
        return this.actionInfo;
    }

    public void commit(Long subjectId, ServiceRequestStateContent content) {
        ServiceRequestContent cv;
        String jsonstr;
        if (content != null) {
            ObjectMapper om = new ObjectMapper();
            om.enable(SerializationFeature.INDENT_OUTPUT);
            try {
                jsonstr = om.writeValueAsString((Object)content);
            }
            catch (JsonProcessingException e) {
                this.logger.error("Error setting content", (Throwable)e);
                throw new RuntimeException("Error setting content", e);
            }
        } else {
            jsonstr = "{}";
        }
        if ((cv = this.getContent()) instanceof ServiceRequestContentView) {
            this.updateContent((ServiceRequestContentView)cv);
        } else {
            this.setContent(cv);
        }
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dao.addLifeCycleTransition(this.dto, subjectId, jsonstr);
        }
    }

    @Override
    public void commit(ServiceRequestStateContent content) {
        this.commit(this.userId, content);
    }
}

