/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import opencard.core.OpenCardException;
import opencard.core.service.SmartCard;
import org.openscdp.pkicard.ServiceRequestCardAction;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.action.ServiceRequestActionStates;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateContent;
import org.openscdp.pkidm.servicerequest.ServiceRequestStateError;
import org.openscdp.pkihsmsrv.HSMService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRequestSmartCardHSMAction
extends ServiceRequestCardAction {
    private final Logger logger = LoggerFactory.getLogger(ServiceRequestSmartCardHSMAction.class);

    public ServiceRequestSmartCardHSMAction(ServiceRequest serviceRequest) {
        super("action.ServiceRequestCardAction", serviceRequest);
    }

    public ServiceRequestSmartCardHSMAction(String key, ServiceRequest serviceRequest) {
        super(key, serviceRequest);
    }

    public JSONActionResult execute(String tokenPath) {
        HSMService hsmService = PKIDMContext.getHSMService();
        SmartCardHSMProvider provider = hsmService.getProvider(tokenPath);
        if (provider == null) {
            return new JSONActionResult(ServiceRequestActionStates.FAILED, "Token " + tokenPath + " is not connected");
        }
        if (!provider.getSmartCardHSMCardService().isSecureAuthenticatedSession()) {
            return new JSONActionResult(ServiceRequestActionStates.FAILED, "Token " + tokenPath + " is not authenticated");
        }
        try {
            this.execute(provider);
            this.postProcessForHSMServiceToken(provider);
            this.updateState(ServiceRequestActionStates.COMPLETED);
            this.serviceRequest.commit(null);
        }
        catch (ServiceRequestActionException e) {
            this.logger.error("Action error", (Throwable)e);
            this.updateState(ServiceRequestActionStates.FAILED, e.getMessage());
            this.serviceRequest.commit((ServiceRequestStateContent)new ServiceRequestStateError(e.getMessage()));
        }
        return this.getStatus();
    }

    protected void postProcessForHSMServiceToken(SmartCardHSMProvider provider) {
    }

    public void execute(SmartCardHSMProvider provider) {
    }

    @Override
    public void execute(SmartCard card) throws OpenCardException {
        SmartCardHSMCardService schsm;
        try {
            schsm = (SmartCardHSMCardService)card.getCardService(SmartCardHSMCardService.class, true);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("SmartCardHSMCardService not found", e);
        }
        SmartCardHSMProvider provider = new SmartCardHSMProvider("Session", false);
        provider.setSmartCardHSMCardService(schsm);
        this.execute(provider);
    }
}

