/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.ejbca.connector.pkidm.action;

import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.Provider;
import java.security.ProviderException;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.namespace.QName;
import org.ejbca.core.protocol.ws.client.gen.EjbcaWS;
import org.ejbca.core.protocol.ws.client.gen.EjbcaWSService;
import org.openscdp.ejbca.connector.pkidm.servicerequest.EJBCAServiceRequest;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EJBCAAction
extends ServiceRequestSmartCardHSMAction {
    final Logger logger = LoggerFactory.getLogger(EJBCAAction.class);
    protected EJBCAServiceRequest sr;

    public EJBCAAction(EJBCAServiceRequest serviceRequest) {
        super((ServiceRequest)serviceRequest);
        this.sr = serviceRequest;
    }

    protected void configureSSL(SmartCardHSMProvider provider) {
        try {
            KeyStore ksKeys = KeyStore.getInstance("SmartCardHSMKeyStore", (Provider)provider);
            ksKeys.load(null, null);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ksKeys, null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ksKeys);
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), SecureRandom.getInstanceStrong());
            SSLSocketFactory sf = ctx.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sf);
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession sslSession) {
                    return hostname.equals("localhost");
                }
            });
        }
        catch (Exception e) {
            throw new ProviderException(e.getMessage(), e);
        }
    }

    public EjbcaWS getEjbcaWSPort() {
        URL url;
        QName qname = new QName("http://ws.protocol.core.ejbca.org/", "EjbcaWSService");
        try {
            url = new URL(this.sr.getEJBCAURL());
        }
        catch (MalformedURLException e) {
            throw new ServiceRequestActionException("Malformed EJBCA URL (SR-ID: " + this.sr.getId() + "): " + e.getMessage(), (Throwable)e);
        }
        EjbcaWSService service = new EjbcaWSService(url, qname);
        EjbcaWS port = service.getEjbcaWSPort();
        return port;
    }
}

