/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.ejbca.connector.jetty;

import de.cardcontact.opencard.web.RemoteTerminalServlet;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.security.Provider;
import java.security.Security;
import java.util.EnumSet;
import java.util.EventListener;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.eclipse.jetty.ee10.servlet.DefaultServlet;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.openscdp.ejbca.connector.EJBCAConnectorServletContextListener;
import org.openscdp.pkiapi.EnforceTLSFilter;
import org.openscdp.server.jetty.BaseServer;

public class Launcher
extends BaseServer {
    protected void configureContext(ServletContextHandler context) {
        context.addEventListener((EventListener)((Object)new EJBCAConnectorServletContextListener()));
        ServletHolder h = new ServletHolder((Servlet)new DefaultServlet());
        context.addServlet(h, "/");
        RemoteTerminalServlet rts = new RemoteTerminalServlet();
        context.addServlet(new ServletHolder((Servlet)rts), "/rt/*");
        EnforceTLSFilter enforceTLSFilter = new EnforceTLSFilter();
        String allowedclients = this.config.getProperty("server.allowedclients");
        if (allowedclients != null) {
            String[] elements;
            for (String str : elements = allowedclients.split(";")) {
                enforceTLSFilter.addAuthorizedClient(new X500Principal(str));
            }
        }
        context.addFilter(new FilterHolder((Filter)enforceTLSFilter), "/api/*", EnumSet.of(DispatcherType.REQUEST));
        ResourceConfig config = new ResourceConfig();
        config.packages(new String[]{"org.openscdp.pkiapi"});
        context.addServlet(new ServletHolder((Servlet)new ServletContainer(config)), "/api/*");
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        SmartCardHSMProvider p = new SmartCardHSMProvider("SmartCardHSM", false);
        Security.addProvider((Provider)p);
        Launcher launcher = new Launcher();
        launcher.start(args);
    }
}

