/*
 * Decompiled with CFR 0.152.
 */
package opencard.opt.iso.fs;

import java.util.Enumeration;
import java.util.Vector;
import opencard.opt.iso.fs.CardFileAppID;
import opencard.opt.iso.fs.CardFileFileID;
import opencard.opt.iso.fs.CardFilePartialAppID;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardFileShortFileID;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.security.SecurityDomain;

public class CardFilePath
implements SecurityDomain {
    public static final String SYM_SEPARATOR = "/";
    public static final String FID_SEPARATOR = ":";
    public static final String APPID_PREFIX = "#";
    public static final String PARTIALAPPID_POSTFIX = "*";
    public static final String ROOTFILEID = ":3F00";
    protected CardFilePathComponent[] components = null;
    private String string_representation = null;

    private static int separatorAt(String cand, int pos, int len) {
        char[] seps = new char[]{FID_SEPARATOR.charAt(0), SYM_SEPARATOR.charAt(0)};
        for (int i = 0; i < seps.length; ++i) {
            char s = seps[i];
            if (cand.charAt(pos) != s) continue;
            if (pos + 1 < len && cand.charAt(pos + 1) != s) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    private CardFilePath() {
    }

    public CardFilePath(String path) throws CardIOException {
        if (path.length() == 0) {
            throw new CardIOException("empty path");
        }
        Vector<Integer> pis = new Vector<Integer>();
        block5: for (int i = 0; i < path.length(); ++i) {
            switch (CardFilePath.separatorAt(path, i, path.length())) {
                case 0: {
                    continue block5;
                }
                case 1: {
                    pis.addElement(new Integer(i));
                    continue block5;
                }
                case 2: {
                    ++i;
                }
            }
        }
        int compTotal = pis.size() == 0 ? 1 : ((Integer)pis.elementAt(0) == 0 ? pis.size() : pis.size() + 1);
        this.components = new CardFilePathComponent[compTotal];
        int last = 0;
        int compIdx = 0;
        for (int i = 0; i < pis.size(); ++i) {
            int pi = (Integer)pis.elementAt(i);
            String comp = null;
            if (pi == 0) {
                if (path.length() > 1) continue;
                pi = 1;
            }
            comp = path.substring(last, pi);
            last = pi;
            this.components[compIdx] = CardFilePathComponent.createComponent(comp, compIdx, path, compTotal);
            ++compIdx;
        }
        if (compIdx < compTotal) {
            String comp = path.substring(last);
            this.components[compIdx] = CardFilePathComponent.createComponent(comp, compIdx, path, compTotal);
        }
    }

    public CardFilePath(byte[] bites) {
        this.components = new CardFilePathComponent[bites.length / 2 + bites.length % 2];
        int cursor = 0;
        for (int i = 0; i < bites.length; i += 2) {
            this.components[cursor++] = i + 1 == bites.length ? new CardFileShortFileID(bites[i]) : new CardFileFileID(bites[i], bites[i + 1]);
        }
    }

    public CardFilePath(CardFilePath path) {
        this.components = new CardFilePathComponent[path.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = path.components[i];
        }
    }

    public Enumeration components() {
        return new Enumeration(){
            int idx = 0;

            @Override
            public boolean hasMoreElements() {
                return this.idx < CardFilePath.this.components.length;
            }

            public Object nextElement() {
                return CardFilePath.this.components[this.idx++];
            }
        };
    }

    public CardFilePath append(CardFilePath path) {
        int i;
        if (path.components[0] instanceof CardFileAppID || path.components[0] instanceof CardFilePartialAppID) {
            throw new CardIOException("attempt to append (partial) application ID " + String.valueOf(path));
        }
        if (this.components[this.components.length - 1] instanceof CardFileShortFileID) {
            throw new CardIOException("attempt to append after short file ID " + String.valueOf(this));
        }
        CardFilePathComponent[] oldComponents = this.components;
        this.components = new CardFilePathComponent[oldComponents.length + path.components.length];
        for (i = 0; i < oldComponents.length; ++i) {
            this.components[i] = oldComponents[i];
        }
        for (i = 0; i < path.components.length; ++i) {
            this.components[oldComponents.length + i] = path.components[i];
        }
        this.string_representation = null;
        return this;
    }

    public CardFilePath append(CardFilePathComponent comp) {
        if (comp instanceof CardFileAppID || comp instanceof CardFilePartialAppID) {
            throw new CardIOException("attempt to append (partial) application ID " + String.valueOf(comp));
        }
        if (this.components[this.components.length - 1] instanceof CardFileShortFileID) {
            throw new CardIOException("attempt to append after short file ID " + String.valueOf(this));
        }
        CardFilePathComponent[] oldComponents = this.components;
        this.components = new CardFilePathComponent[oldComponents.length + 1];
        for (int i = 0; i < oldComponents.length; ++i) {
            this.components[i] = oldComponents[i];
        }
        this.components[oldComponents.length] = comp;
        this.string_representation = null;
        return this;
    }

    public boolean startsWith(CardFilePath prefix) {
        if (prefix.numberOfComponents() >= this.numberOfComponents()) {
            return false;
        }
        for (int i = 0; i < prefix.numberOfComponents(); ++i) {
            if (prefix.components[i].equals(this.components[i])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object filePath) {
        if (!(filePath instanceof CardFilePath)) {
            return false;
        }
        CardFilePath path = (CardFilePath)filePath;
        if (this.numberOfComponents() != path.numberOfComponents()) {
            return false;
        }
        for (int i = 0; i < path.numberOfComponents(); ++i) {
            if (path.components[i].equals(this.components[i])) continue;
            return false;
        }
        return true;
    }

    public int commonPrefixLength(CardFilePath path) {
        int gcl = this.components.length <= path.components.length ? this.components.length : path.components.length;
        int i = 0;
        for (i = 0; i < gcl && this.components[i].equals(path.components[i]); ++i) {
        }
        return i;
    }

    public CardFilePath greatestCommonPrefix(CardFilePath path) {
        int cpl = this.commonPrefixLength(path);
        if (cpl == 0) {
            throw new IllegalArgumentException("no common prefix");
        }
        CardFilePath common = new CardFilePath();
        common.components = new CardFilePathComponent[cpl + 1];
        for (int i = 0; i < common.components.length; ++i) {
            common.components[i] = this.components[i];
        }
        return common;
    }

    public CardFilePath chompPrefix(CardFilePath prefix) {
        if (!this.startsWith(prefix)) {
            throw new IllegalArgumentException("illegal prefix " + String.valueOf(prefix) + " for path " + this.toString());
        }
        CardFilePathComponent[] oldComponents = this.components;
        this.components = new CardFilePathComponent[oldComponents.length - prefix.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = oldComponents[prefix.components.length + i];
        }
        this.string_representation = null;
        return this;
    }

    public boolean chompTail() {
        if (this.components.length == 1) {
            return false;
        }
        CardFilePathComponent[] oldComponents = this.components;
        this.components = new CardFilePathComponent[oldComponents.length - 1];
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = oldComponents[i];
        }
        this.string_representation = null;
        return true;
    }

    public CardFilePathComponent tail() {
        return this.components[this.components.length - 1];
    }

    public int numberOfComponents() {
        return this.components.length;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.string_representation == null) {
            StringBuffer path = new StringBuffer();
            for (int i = 0; i < this.components.length; ++i) {
                path.append(this.components[i].toString());
            }
            this.string_representation = path.toString();
        }
        return this.string_representation;
    }
}

