/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.kdm;

import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkicard.kdm.CreateKeyDomainAction;
import org.openscdp.pkicard.kdm.DeleteKeyDomainAction;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembership;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembershipAction;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembershipContent;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dao.TokenDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.TokenDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestAction;
import org.openscdp.pkidm.holder.CVCertificateHolder;
import org.openscdp.pkidm.json.JSONAction;
import org.openscdp.pkidm.servicerequest.ServiceRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueKeyDomainMembershipSharedServiceRequest
extends ServiceRequestBase
implements IssueKeyDomainMembership {
    public static final String PROCESS = "IssueKeyDomainMembership";
    private final Logger logger = LoggerFactory.getLogger(IssueKeyDomainMembershipSharedServiceRequest.class);
    protected IssueKeyDomainMembershipContent content;
    private CVCertificateHolder groupMember;

    public IssueKeyDomainMembershipSharedServiceRequest(ServiceRequestDTO dto) {
        super(dto);
    }

    public ServiceRequestAction getActionFor(JSONAction action) {
        if (action.action.equals("action.kess.kdm.issue")) {
            return new IssueKeyDomainMembershipAction(this);
        }
        if (action.action.equals("action.kess.kdm.createkd")) {
            return new CreateKeyDomainAction(this);
        }
        if (action.action.equals("action.kess.kdm.deletekd")) {
            return new DeleteKeyDomainAction(this);
        }
        return null;
    }

    @Override
    public IssueKeyDomainMembershipContent getContent() {
        if (this.content == null) {
            this.content = (IssueKeyDomainMembershipContent)this.getContentView(IssueKeyDomainMembershipContent.class);
        }
        return this.content;
    }

    public String getTokenPath() {
        return this.getContent().getTokenPath();
    }

    @Override
    public CVCertificateHolder getGroupMember() {
        if (this.groupMember == null) {
            try (Handle handle = PKIDMContext.getJDBI().open();){
                HolderDAO dao = (HolderDAO)handle.attach(HolderDAO.class);
                HolderDTO hdto = dao.getHolder(this.getContent().groupMemberHolderId);
                this.groupMember = new CVCertificateHolder(hdto);
            }
        }
        return this.groupMember;
    }

    @Override
    public String getBackendConnectedTo() {
        return this.getBackendConnectedTo(this.getTokenPath());
    }

    @Override
    public String getBackendConnectedTo(String tokenPath) {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            TokenDAO dao = (TokenDAO)handle.attach(TokenDAO.class);
            TokenDTO dto = dao.getToken(tokenPath);
            if (dto.getOnline() == 0L) {
                String string = null;
                return string;
            }
            String string = dto.getLastSeenAt();
            return string;
        }
    }
}

