@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  pki-as-a-service-ejbca startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and PKI_AS_A_SERVICE_EJBCA_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto execute

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto execute

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\pki-as-a-service-ejbca-0.1.25.jar;%APP_HOME%\lib\pki-server-0.1.148.jar;%APP_HOME%\lib\logback-classic-1.4.11.jar;%APP_HOME%\lib\jetty-webapp-11.0.15.jar;%APP_HOME%\lib\pki-api-0.1.148.jar;%APP_HOME%\lib\pki-card-0.1.148.jar;%APP_HOME%\lib\pki-dm-0.1.148.jar;%APP_HOME%\lib\pki-db-0.1.148.jar;%APP_HOME%\lib\jdbi3-sqlobject-3.30.0.jar;%APP_HOME%\lib\jdbi3-core-3.30.0.jar;%APP_HOME%\lib\pki-hsm-srv-0.1.148.jar;%APP_HOME%\lib\sc-hsm-provider-2.0.70.jar;%APP_HOME%\lib\jetty-servlet-11.0.15.jar;%APP_HOME%\lib\jetty-xml-11.0.15.jar;%APP_HOME%\lib\jetty-security-11.0.15.jar;%APP_HOME%\lib\jetty-server-11.0.15.jar;%APP_HOME%\lib\jetty-http-11.0.15.jar;%APP_HOME%\lib\jetty-io-11.0.15.jar;%APP_HOME%\lib\jetty-util-11.0.15.jar;%APP_HOME%\lib\slf4j-api-2.0.9.jar;%APP_HOME%\lib\logback-core-1.4.11.jar;%APP_HOME%\lib\bcpkix-jdk18on-1.76.jar;%APP_HOME%\lib\bcutil-jdk18on-1.76.jar;%APP_HOME%\lib\bcprov-jdk18on-1.76.jar;%APP_HOME%\lib\jaxws-rt-4.0.3.jar;%APP_HOME%\lib\jersey-media-json-jackson-3.0.5.jar;%APP_HOME%\lib\jackson-module-jakarta-xmlbind-annotations-2.13.3.jar;%APP_HOME%\lib\jackson-annotations-2.13.3.jar;%APP_HOME%\lib\jackson-core-2.13.3.jar;%APP_HOME%\lib\jackson-databind-2.13.3.jar;%APP_HOME%\lib\jersey-container-servlet-3.0.5.jar;%APP_HOME%\lib\jersey-hk2-3.0.5.jar;%APP_HOME%\lib\mariadb-java-client-3.0.6.jar;%APP_HOME%\lib\ocf-web-2.0.90.jar;%APP_HOME%\lib\ocf-core-2.0.90.jar;%APP_HOME%\lib\jaxb-impl-4.0.5.jar;%APP_HOME%\lib\ha-api-3.1.13.jar;%APP_HOME%\lib\gmbal-api-only-4.0.3.jar;%APP_HOME%\lib\management-api-3.2.3.jar;%APP_HOME%\lib\streambuffer-2.1.0.jar;%APP_HOME%\lib\saaj-impl-3.0.4.jar;%APP_HOME%\lib\stax-ex-2.1.0.jar;%APP_HOME%\lib\mimepull-1.10.0.jar;%APP_HOME%\lib\FastInfoset-2.1.1.jar;%APP_HOME%\lib\angus-mail-2.0.3.jar;%APP_HOME%\lib\jakarta.mail-api-2.1.3.jar;%APP_HOME%\lib\jaxb-core-4.0.5.jar;%APP_HOME%\lib\angus-activation-2.0.2.jar;%APP_HOME%\lib\woodstox-core-7.0.0.jar;%APP_HOME%\lib\stax2-api-4.2.2.jar;%APP_HOME%\lib\jakarta.xml.ws-api-4.0.2.jar;%APP_HOME%\lib\jakarta.xml.bind-api-4.0.2.jar;%APP_HOME%\lib\jakarta.xml.soap-api-3.0.2.jar;%APP_HOME%\lib\jakarta.activation-api-2.1.3.jar;%APP_HOME%\lib\jersey-container-servlet-core-3.0.5.jar;%APP_HOME%\lib\jersey-server-3.0.5.jar;%APP_HOME%\lib\jersey-client-3.0.5.jar;%APP_HOME%\lib\jersey-common-3.0.5.jar;%APP_HOME%\lib\jakarta.annotation-api-3.0.0.jar;%APP_HOME%\lib\jersey-entity-filtering-3.0.5.jar;%APP_HOME%\lib\jakarta.ws.rs-api-3.0.0.jar;%APP_HOME%\lib\hk2-locator-3.0.3.jar;%APP_HOME%\lib\javassist-3.28.0-GA.jar;%APP_HOME%\lib\geantyref-1.3.13.jar;%APP_HOME%\lib\caffeine-3.0.3.jar;%APP_HOME%\lib\hk2-api-3.0.3.jar;%APP_HOME%\lib\hk2-utils-3.0.3.jar;%APP_HOME%\lib\jakarta.inject-api-2.0.1.jar;%APP_HOME%\lib\osgi-resource-locator-1.0.3.jar;%APP_HOME%\lib\jakarta.validation-api-3.0.0.jar;%APP_HOME%\lib\aopalliance-repackaged-3.0.3.jar;%APP_HOME%\lib\jakarta.activation-2.0.1.jar;%APP_HOME%\lib\jetty-jakarta-servlet-api-5.0.2.jar


@rem Execute pki-as-a-service-ejbca
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %PKI_AS_A_SERVICE_EJBCA_OPTS%  -classpath "%CLASSPATH%" org.openscdp.ejbca.connector.jetty.Launcher %*

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable PKI_AS_A_SERVICE_EJBCA_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%PKI_AS_A_SERVICE_EJBCA_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
